/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tinkering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.traits.ITrait;

public class PartMaterialType {
    private final Set<IToolPart> neededPart = new HashSet<IToolPart>();
    private final String[] neededTypes;

    public PartMaterialType(IToolPart part, String ... statIDs) {
        this.neededPart.add(part);
        this.neededTypes = statIDs;
    }

    public boolean isValid(ItemStack stack) {
        if (stack == null || stack.getItem() == null) {
            return false;
        }
        if (!(stack.getItem() instanceof IToolPart)) {
            return false;
        }
        IToolPart toolPart = (IToolPart)stack.getItem();
        return this.isValid(toolPart, toolPart.getMaterial(stack));
    }

    public boolean isValid(IToolPart part, Material material) {
        return this.isValidItem(part) && this.isValidMaterial(material);
    }

    public boolean isValidItem(IToolPart part) {
        return this.neededPart.contains(part);
    }

    public boolean isValidMaterial(Material material) {
        for (String type : this.neededTypes) {
            if (material.hasStats(type)) continue;
            return false;
        }
        return true;
    }

    public boolean usesStat(String statID) {
        for (String type : this.neededTypes) {
            if (!type.equals(statID)) continue;
            return true;
        }
        return false;
    }

    public Collection<ITrait> getApplicableTraitsForMaterial(Material material) {
        if (!this.isValidMaterial(material)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder traits = ImmutableList.builder();
        for (String type : this.neededTypes) {
            traits.addAll(material.getAllTraitsForStats(type));
        }
        if (traits.build().isEmpty()) {
            traits.addAll(material.getDefaultTraits());
        }
        return traits.build();
    }

    public Set<IToolPart> getPossibleParts() {
        return ImmutableSet.copyOf(this.neededPart);
    }

    public static PartMaterialType head(IToolPart part) {
        return new PartMaterialType(part, "head");
    }

    public static PartMaterialType handle(IToolPart part) {
        return new PartMaterialType(part, "handle");
    }

    public static PartMaterialType extra(IToolPart part) {
        return new PartMaterialType(part, "extra");
    }
}

