/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;

public class PatternTexture
extends TextureColoredTexture {
    public PatternTexture(String partTexture, TextureAtlasSprite patternTexture, String spriteName) {
        super(partTexture, patternTexture, spriteName);
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        if (RenderUtil.alpha(pixel) == 0) {
            return pixel;
        }
        if (this.textureData == null) {
            this.loadData();
        }
        if (this.width > this.textureW) {
            int texX = (int)((float)this.getX(pxCoord) * this.scale);
            int texY = (int)((float)this.getY(pxCoord) * this.scale);
            pxCoord = texY * this.textureW + texX;
        }
        int x = pxCoord % this.textureW;
        int y = pxCoord / this.textureH;
        int x2 = x - this.offsetX;
        int y2 = y - this.offsetY;
        if (x2 >= this.textureW || x2 < 0 || y2 >= this.textureH || y2 < 0) {
            return pixel;
        }
        if (x < this.textureW / 8 || x > this.textureW - this.textureW / 8 || y < this.textureH / 8 || y > this.textureH - this.textureH / 8) {
            return pixel;
        }
        int c = this.textureData[mipmap][this.coord2(x2, y2)];
        int a = RenderUtil.alpha(c);
        float mult = 1.0f;
        if (a < 64) {
            return pixel;
        }
        boolean edge = false;
        if (x > 0 && (a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x - 1, y)])) < 64) {
            edge = true;
        }
        if (y < this.height - 1 && (a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x, y + 1)])) < 64) {
            edge = true;
        }
        if (x < this.width - 1 && (a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x + 1, y)])) < 64) {
            edge = true;
        }
        if (y > 0 && (a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x, y - 1)])) < 64) {
            edge = true;
        }
        mult = 0.5f;
        if (edge) {
            mult = 0.6f;
        }
        int r = (int)((float)RenderUtil.red(pixel) * mult);
        int g = (int)((float)RenderUtil.green(pixel) * mult);
        int b = (int)((float)RenderUtil.blue(pixel) * mult);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return RenderUtil.compose(r, g, b, 255);
    }
}

