/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;

public class CastTexture
extends TextureColoredTexture {
    public CastTexture(String addTextureLocation, TextureAtlasSprite baseTexture, String spriteName) {
        super(addTextureLocation, baseTexture, spriteName);
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        if (RenderUtil.alpha(pixel) == 0) {
            return pixel;
        }
        if (this.textureData == null) {
            this.loadData();
        }
        if (this.width > this.textureW) {
            int texX = (int)((float)this.getX(pxCoord) * this.scale);
            int texY = (int)((float)this.getY(pxCoord) * this.scale);
            pxCoord = texY * this.textureW + texX;
        }
        int x2 = pxCoord % this.textureW;
        int y2 = pxCoord / this.textureH;
        int x = x2 - this.offsetX;
        int y = y2 - this.offsetY;
        if (x >= this.textureW || x < 0 || y >= this.textureH || y < 0) {
            return pixel;
        }
        int c = this.textureData[mipmap][this.coord2(x, y)];
        int a = RenderUtil.alpha(c);
        float mult = 1.0f;
        if (a > 64 && x2 != 0 && x2 != this.textureW - 1 && y2 != 0 && y2 != this.textureH - 1) {
            return 0;
        }
        int count = 0;
        boolean edge = false;
        a = 0;
        if (x > 0) {
            a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x - 1, y)]);
        }
        if (a < 64) {
            ++count;
            edge = true;
        }
        a = 0;
        if (y < this.textureH - 1) {
            a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x, y + 1)]);
        }
        if (a < 64) {
            ++count;
            edge = true;
        }
        a = 0;
        if (x < this.textureW - 1) {
            a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x + 1, y)]);
        }
        if (a < 64) {
            ++count;
            edge = true;
        }
        a = 0;
        if (y > 0) {
            a = RenderUtil.alpha(this.textureData[mipmap][this.coord2(x, y - 1)]);
        }
        if (a < 64) {
            count -= 3;
            edge = true;
        }
        if (!edge || count == 0) {
            return pixel;
        }
        if (count < 0) {
            mult = 0.8f;
        } else if (count > 0) {
            mult = 1.1f;
        }
        int r = (int)((float)RenderUtil.red(pixel) * mult);
        int g = (int)((float)RenderUtil.green(pixel) * mult);
        int b = (int)((float)RenderUtil.blue(pixel) * mult);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return RenderUtil.compose(r, g, b, 255);
    }
}

