/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.utils.TagUtil;

public class BakedToolModel
extends ItemLayerModel.BakedModel
implements ISmartItemModel,
IPerspectiveAwareModel {
    protected BakedMaterialModel[] parts;
    protected BakedMaterialModel[] brokenParts;
    protected Map<String, IFlexibleBakedModel> modifierParts;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private static final List<List<BakedQuad>> empty_face_quads;
    private static final List<BakedQuad> empty_list;

    public BakedToolModel(IFlexibleBakedModel parent, BakedMaterialModel[] parts, BakedMaterialModel[] brokenParts, Map<String, IFlexibleBakedModel> modifierParts, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform) {
        super((ImmutableList)parent.getGeneralQuads(), parent.getParticleTexture(), parent.getFormat());
        if (parts.length != brokenParts.length) {
            throw new RuntimeException("TinkerModel: Length of Parts and BrokenParts Array has to match");
        }
        this.parts = parts;
        this.brokenParts = brokenParts;
        this.modifierParts = modifierParts;
        this.transforms = transform;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        int i;
        NBTTagCompound baseTag = TagUtil.getBaseTag(stack);
        NBTTagCompound toolTag = TagUtil.getToolTag(stack);
        if (baseTag.hasNoTags()) {
            return this;
        }
        NBTTagList materials = TagUtil.getBaseMaterialsTagList(stack);
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(stack);
        ImmutableList.Builder quads = ImmutableList.builder();
        boolean broken = toolTag.getBoolean("Broken");
        for (i = 0; i < this.parts.length; ++i) {
            String id = materials.getStringTagAt(i);
            IFlexibleBakedModel partModel = broken && this.brokenParts[i] != null ? this.brokenParts[i].getModelByIdentifier(id) : this.parts[i].getModelByIdentifier(id);
            quads.addAll((Iterable)partModel.getGeneralQuads());
        }
        for (i = 0; i < modifiers.tagCount(); ++i) {
            String modId = modifiers.getStringTagAt(i);
            IFlexibleBakedModel modModel = this.modifierParts.get(modId);
            if (modModel == null) continue;
            quads.addAll((Iterable)modModel.getGeneralQuads());
        }
        ItemLayerModel.BakedModel model = new ItemLayerModel.BakedModel(quads.build(), this.getParticleTexture(), this.getFormat());
        return new IPerspectiveAwareModel.MapWrapper((IFlexibleBakedModel)model, this.transforms);
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    static {
        empty_list = Collections.emptyList();
        empty_face_quads = Lists.newArrayList();
        for (int i = 0; i < 6; ++i) {
            empty_face_quads.add(empty_list);
        }
    }
}

