/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.SlimeBounceHandler;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.tools.network.EntityMovementChangePacket;

public class ItemSlimeSling
extends Item {
    public ItemSlimeSling() {
        this.setMaxStackSize(1);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabGadgets);
    }

    public ItemStack onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        playerIn.setItemInUse(itemStackIn, this.getMaxItemUseDuration(itemStackIn));
        return itemStackIn;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        MovingObjectPosition mop;
        if (!player.onGround) {
            return;
        }
        int i = this.getMaxItemUseDuration(stack) - timeLeft;
        float f = (float)i / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if ((f *= 4.0f) > 6.0f) {
            f = 6.0f;
        }
        if ((mop = this.getMovingObjectPositionFromPlayer(world, player, false)) != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            Vec3 vec = player.getLookVec().normalize();
            player.addVelocity(vec.xCoord * (double)(-f), vec.yCoord * (double)(-f) / 3.0, vec.zCoord * (double)(-f));
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                TinkerNetwork.sendTo((AbstractPacket)new EntityMovementChangePacket((Entity)player), playerMP);
            }
            player.playSound(Sounds.slimesling, 1.0f, 1.0f);
            SlimeBounceHandler.addBounceHandler((EntityLivingBase)player);
        }
    }
}

