/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.client.SlimeColorizer;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class BlockSlimeLeaves
extends BlockLeaves {
    public BlockSlimeLeaves() {
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabWorld);
        this.func_149711_c(0.3f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (BlockSlimeGrass.FoliageType type : BlockSlimeGrass.FoliageType.values()) {
            list.add(new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    protected int func_176232_d(IBlockState state) {
        return 25;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)TinkerWorld.slimeSapling);
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (worldIn.field_73012_v.nextInt(chance) == 0) {
            ItemStack stack = null;
            if (state.func_177229_b(BlockSlimeGrass.FOLIAGE) == BlockSlimeGrass.FoliageType.PURPLE) {
                stack = TinkerCommons.matSlimeBallPurple.func_77946_l();
            } else if (state.func_177229_b(BlockSlimeGrass.FOLIAGE) == BlockSlimeGrass.FoliageType.BLUE) {
                stack = worldIn.field_73012_v.nextInt(3) == 0 ? TinkerCommons.matSlimeBallBlue.func_77946_l() : new ItemStack(Items.field_151123_aH);
            }
            if (stack != null) {
                BlockSlimeLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE))).ordinal() & 3;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE))).ordinal() & 3);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BlockSlimeGrass.FOLIAGE, field_176236_b, field_176237_a});
    }

    public IBlockState func_176203_a(int meta) {
        int type = meta % 4;
        if (type < 0 || type >= BlockSlimeGrass.FoliageType.values().length) {
            type = 0;
        }
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.values()[type];
        return this.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)grass)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE))).ordinal() & 3;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        BlockSlimeGrass.FoliageType foliageType = (BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE));
        return SlimeColorizer.getColorStatic(foliageType);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_149635_D();
        }
        BlockSlimeGrass.FoliageType foliageType = (BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE));
        return SlimeColorizer.getColorForPos(pos.func_177963_a(128.0, 0.0, 128.0), foliageType);
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        throw new NotImplementedException();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_180643_i(state)});
    }

    public boolean isLeaves(IBlockAccess world, BlockPos pos) {
        return true;
    }
}

