/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import java.util.ListIterator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModSoulbound
extends Modifier {
    public ModSoulbound() {
        super("soulbound");
        this.addAspects(new ModifierAspect.DataAspect((IModifier)this, 16120748), new ModifierAspect.SingleAspect(this));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDropsEvent event) {
        if (event.entityPlayer == null || event.entityPlayer instanceof FakePlayer || event.isCanceled()) {
            return;
        }
        if (event.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        ListIterator iter = event.drops.listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack stack = ei.func_92059_d();
            if (!TinkerUtil.hasModifier(stack.func_77978_p(), this.identifier)) continue;
            event.entityPlayer.field_71071_by.func_70441_a(stack);
            iter.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(PlayerEvent.Clone evt) {
        if (!evt.wasDeath || evt.isCanceled()) {
            return;
        }
        if (evt.original == null || evt.entityPlayer == null || evt.entityPlayer instanceof FakePlayer) {
            return;
        }
        if (evt.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        for (int i = 0; i < evt.original.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = evt.original.field_71071_by.field_70462_a[i];
            if (stack == null || !TinkerUtil.hasModifier(stack.func_77978_p(), this.identifier)) continue;
            evt.entityPlayer.field_71071_by.func_70441_a(stack);
            evt.original.field_71071_by.field_70462_a[i] = null;
        }
    }
}

