/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.texture.ExtraUtilityTexture;
import slimeknights.tconstruct.library.client.texture.MetalColoredTexture;
import slimeknights.tconstruct.library.client.texture.MetalTextureTexture;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.traits.TraitAlien;
import slimeknights.tconstruct.tools.traits.TraitAquadynamic;
import slimeknights.tconstruct.tools.traits.TraitAridiculous;
import slimeknights.tconstruct.tools.traits.TraitAutosmelt;
import slimeknights.tconstruct.tools.traits.TraitBaconlicious;
import slimeknights.tconstruct.tools.traits.TraitBonusDamage;
import slimeknights.tconstruct.tools.traits.TraitCheap;
import slimeknights.tconstruct.tools.traits.TraitCheapskate;
import slimeknights.tconstruct.tools.traits.TraitColdblooded;
import slimeknights.tconstruct.tools.traits.TraitCrude;
import slimeknights.tconstruct.tools.traits.TraitCrumbling;
import slimeknights.tconstruct.tools.traits.TraitDense;
import slimeknights.tconstruct.tools.traits.TraitDepthdigger;
import slimeknights.tconstruct.tools.traits.TraitDuritos;
import slimeknights.tconstruct.tools.traits.TraitEcological;
import slimeknights.tconstruct.tools.traits.TraitEnderference;
import slimeknights.tconstruct.tools.traits.TraitEstablished;
import slimeknights.tconstruct.tools.traits.TraitFlammable;
import slimeknights.tconstruct.tools.traits.TraitHellish;
import slimeknights.tconstruct.tools.traits.TraitHoly;
import slimeknights.tconstruct.tools.traits.TraitInsatiable;
import slimeknights.tconstruct.tools.traits.TraitJagged;
import slimeknights.tconstruct.tools.traits.TraitLightweight;
import slimeknights.tconstruct.tools.traits.TraitMagnetic;
import slimeknights.tconstruct.tools.traits.TraitMomentum;
import slimeknights.tconstruct.tools.traits.TraitPetramor;
import slimeknights.tconstruct.tools.traits.TraitPoisonous;
import slimeknights.tconstruct.tools.traits.TraitPrickly;
import slimeknights.tconstruct.tools.traits.TraitSharp;
import slimeknights.tconstruct.tools.traits.TraitShocking;
import slimeknights.tconstruct.tools.traits.TraitSlimey;
import slimeknights.tconstruct.tools.traits.TraitSpiky;
import slimeknights.tconstruct.tools.traits.TraitSplintering;
import slimeknights.tconstruct.tools.traits.TraitSplinters;
import slimeknights.tconstruct.tools.traits.TraitSqueaky;
import slimeknights.tconstruct.tools.traits.TraitStiff;
import slimeknights.tconstruct.tools.traits.TraitStonebound;
import slimeknights.tconstruct.tools.traits.TraitSuperheat;
import slimeknights.tconstruct.tools.traits.TraitTasty;
import slimeknights.tconstruct.tools.traits.TraitUnnatural;
import slimeknights.tconstruct.tools.traits.TraitWritable;
import slimeknights.tconstruct.world.entity.EntityBlueSlime;

@Pulse(id="TinkerMaterials", description="All the tool materials added by TConstruct", pulsesRequired="TinkerTools", forced=true)
public final class TinkerMaterials {
    static final String PulseId = "TinkerMaterials";
    static final Logger log = Util.getLogger("TinkerMaterials");
    public static final List<Material> materials = Lists.newArrayList();
    public static final Material wood = TinkerMaterials.mat("wood", 9332251);
    public static final Material stone = TinkerMaterials.mat("stone", 0x999999);
    public static final Material flint = TinkerMaterials.mat("flint", 0x696969);
    public static final Material cactus = TinkerMaterials.mat("cactus", 41231);
    public static final Material bone = TinkerMaterials.mat("bone", 15591103);
    public static final Material obsidian = TinkerMaterials.mat("obsidian", 6298820);
    public static final Material prismarine = TinkerMaterials.mat("prismarine", 8314556);
    public static final Material endstone = TinkerMaterials.mat("endstone", 14735504);
    public static final Material paper = TinkerMaterials.mat("paper", 0xFFFFFF);
    public static final Material sponge = TinkerMaterials.mat("sponge", 13290574);
    public static final Material firewood = TinkerMaterials.mat("firewood", 13390592);
    public static final Material knightslime = TinkerMaterials.mat("knightslime", 15831024);
    public static final Material slime = TinkerMaterials.mat("slime", 8570995);
    public static final Material blueslime = TinkerMaterials.mat("blueslime", 7653575);
    public static final Material magmaslime = TinkerMaterials.mat("magmaslime", 16750093);
    public static final Material iron = TinkerMaterials.mat("iron", 0xCACACA);
    public static final Material pigiron = TinkerMaterials.mat("pigiron", 15703707);
    public static final Material netherrack = TinkerMaterials.mat("netherrack", 12078927);
    public static final Material ardite = TinkerMaterials.mat("ardite", 13713936);
    public static final Material cobalt = TinkerMaterials.mat("cobalt", 2654932);
    public static final Material manyullyn = TinkerMaterials.mat("manyullyn", 10575096);
    public static final Material copper = TinkerMaterials.mat("copper", 15572743);
    public static final Material bronze = TinkerMaterials.mat("bronze", 14925160);
    public static final Material lead = TinkerMaterials.mat("lead", 5065064);
    public static final Material silver = TinkerMaterials.mat("silver", 13757686);
    public static final Material electrum = TinkerMaterials.mat("electrum", 15260489);
    public static final Material steel = TinkerMaterials.mat("steel", 0xA7A7A7);
    public static final Material xu;
    public static final AbstractTrait alien;
    public static final AbstractTrait aquadynamic;
    public static final AbstractTrait aridiculous;
    public static final AbstractTrait autosmelt;
    public static final AbstractTrait baconlicious;
    public static final AbstractTrait cheap;
    public static final AbstractTrait cheapskate;
    public static final AbstractTrait coldblooded;
    public static final AbstractTrait crude;
    public static final AbstractTrait crude2;
    public static final AbstractTrait crumbling;
    public static final AbstractTrait dense;
    public static final AbstractTrait depthdigger;
    public static final AbstractTrait duritos;
    public static final AbstractTrait ecological;
    public static final AbstractTrait enderference;
    public static final AbstractTrait established;
    public static final AbstractTrait flammable;
    public static final AbstractTrait fractured;
    public static final AbstractTrait hellish;
    public static final AbstractTrait holy;
    public static final AbstractTrait insatiable;
    public static final AbstractTrait jagged;
    public static final AbstractTrait lightweight;
    public static final AbstractTrait magnetic;
    public static final AbstractTrait magnetic2;
    public static final AbstractTrait momentum;
    public static final AbstractTrait petramor;
    public static final AbstractTrait poisonous;
    public static final AbstractTrait prickly;
    public static final AbstractTrait sharp;
    public static final AbstractTrait shocking;
    public static final AbstractTrait slimeyGreen;
    public static final AbstractTrait slimeyBlue;
    public static final AbstractTrait spiky;
    public static final AbstractTrait splintering;
    public static final AbstractTrait splinters;
    public static final AbstractTrait squeaky;
    public static final AbstractTrait superheat;
    public static final AbstractTrait stiff;
    public static final AbstractTrait stonebound;
    public static final AbstractTrait tasty;
    public static final AbstractTrait unnatural;
    public static final AbstractTrait writable;
    public static final AbstractTrait writable2;
    private static final String HEAD = "head";

    private static Material mat(String name, int color) {
        Material mat = new Material(name, color);
        materials.add(mat);
        return mat;
    }

    @Subscribe
    public void registerRendering(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            TinkerMaterials.registerMaterialRendering();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerMaterialRendering() {
        wood.setRenderInfo(new MaterialRenderInfo.MultiColor(7231274, 7626552, 9332509));
        stone.setRenderInfo(0x696969);
        flint.setRenderInfo(0xFFFFFF).setTextureSuffix("contrast");
        cactus.setRenderInfo(27914);
        obsidian.setRenderInfo(new MaterialRenderInfo.MultiColor(7428252, 9396436, 9196511).setTextureSuffix("contrast"));
        prismarine.setRenderInfo(new MaterialRenderInfo.BlockTexture("minecraft:blocks/prismarine_bricks"));
        netherrack.setRenderInfo(new MaterialRenderInfo.BlockTexture("minecraft:blocks/netherrack"));
        endstone.setRenderInfo(new MaterialRenderInfo.InverseMultiColor(6054550, 3949174, 2173558));
        firewood.setRenderInfo(new MaterialRenderInfo.BlockTexture("tconstruct:blocks/firewood"));
        bone.setRenderInfo(15591103).setTextureSuffix("bone_base");
        paper.setRenderInfo(0xFFFFFF);
        sponge.setRenderInfo(new MaterialRenderInfo.BlockTexture("minecraft:blocks/sponge"));
        slime.setRenderInfo(8570995);
        blueslime.setRenderInfo(7653575);
        magmaslime.setRenderInfo(new MaterialRenderInfo.MultiColor(11036475, 16747593, 16751933));
        iron.setRenderInfo(new MaterialRenderInfo.Metal(0xCACACA, 0.0f, 0.3f, 0.0f));
        cobalt.setRenderInfo(new MaterialRenderInfo.Metal(1522549, 0.25f, 0.5f, -0.1f));
        ardite.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new MetalTextureTexture(Util.resource("items/materials/ardite_rust"), baseTexture, location, 16347671, 0.6f, 0.4f, 0.1f);
            }
        });
        manyullyn.setRenderInfo(new MaterialRenderInfo.Metal(11091445, 0.4f, 0.2f, -0.1f));
        pigiron.setRenderInfo(new MaterialRenderInfo.Metal(13859960, 0.1f, 0.1f, 0.0f));
        knightslime.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new MetalColoredTexture(baseTexture, location, 6839248, 0.0f, 0.5f, 0.3f);
            }
        });
        copper.setRenderInfo(new MaterialRenderInfo.Metal(15704149, 0.25f, 0.25f, -0.05f));
        bronze.setRenderInfo(new MaterialRenderInfo.Metal(14925160, 0.25f, 0.15f, -0.05f));
        lead.setRenderInfo(new MaterialRenderInfo.Metal(5065064, 0.0f, 0.15f, 0.2f));
        silver.setRenderInfo(new MaterialRenderInfo.Metal(13757686, 1.0f, 0.5f, 0.1f));
        electrum.setRenderInfo(new MaterialRenderInfo.Metal(15588689, 0.15f, 0.25f, -0.05f));
        steel.setRenderInfo(new MaterialRenderInfo.Metal(0x888888, 0.1f, 0.3f, 0.1f));
        xu.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new ExtraUtilityTexture(baseTexture, location);
            }
        });
    }

    @Subscribe
    public void setupMaterials(FMLInitializationEvent event) {
        wood.setCraftable(true);
        wood.addItem("stickWood", 1, 72);
        wood.addItem("plankWood", 1, 144);
        wood.addItem("logWood", 1, 576);
        wood.setRepresentativeItem(new ItemStack(Items.field_151055_y));
        wood.addTrait(ecological, HEAD);
        wood.addTrait(splinters);
        wood.addTrait(ecological);
        stone.setCraftable(true);
        stone.addItem("cobblestone", 1, 144);
        stone.addItem("stone", 1, 144);
        stone.setRepresentativeItem(new ItemStack(Blocks.field_150347_e));
        stone.addTrait(cheapskate, HEAD);
        stone.addTrait(cheap);
        flint.setCraftable(true);
        flint.addItem(Items.field_151145_ak, 1, 144);
        flint.setRepresentativeItem(new ItemStack(Items.field_151145_ak));
        flint.addTrait(crude2, HEAD);
        flint.addTrait(crude);
        cactus.setCraftable(true);
        cactus.addItem("blockCactus", 1, 144);
        cactus.setRepresentativeItem(new ItemStack((Block)Blocks.field_150434_aF));
        cactus.addTrait(prickly, HEAD);
        cactus.addTrait(spiky);
        obsidian.setFluid(TinkerFluids.obsidian);
        obsidian.setCraftable(true);
        obsidian.setCastable(true);
        obsidian.addItem(Blocks.field_150343_Z, 144);
        obsidian.setRepresentativeItem(new ItemStack(Blocks.field_150343_Z));
        obsidian.addTrait(duritos);
        prismarine.setCraftable(true);
        prismarine.addItem(Items.field_179562_cC, 1, 36);
        prismarine.addItem(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176331_b), 1, 144);
        prismarine.addItem(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176333_M), 1, 324);
        prismarine.addItem(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176334_N), 1, 288);
        prismarine.setRepresentativeItem(Blocks.field_180397_cI);
        prismarine.addTrait(jagged, HEAD);
        prismarine.addTrait(aquadynamic);
        netherrack.setCraftable(true);
        netherrack.addItem(Blocks.field_150424_aL, 144);
        netherrack.setRepresentativeItem(Blocks.field_150424_aL);
        netherrack.addTrait(aridiculous, HEAD);
        netherrack.addTrait(hellish);
        endstone.setCraftable(true);
        endstone.addItem(Blocks.field_150377_bs, 144);
        endstone.setRepresentativeItem(Blocks.field_150377_bs);
        endstone.addTrait(alien, HEAD);
        endstone.addTrait(enderference);
        bone.setCraftable(true);
        bone.addItem(Items.field_151103_aS, 1, 144);
        bone.addItem(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), 1, 36);
        bone.setRepresentativeItem(Items.field_151103_aS);
        bone.addTrait(splintering, HEAD);
        bone.addTrait(fractured);
        paper.setCraftable(true);
        paper.addItem(Items.field_151121_aF, 1, 36);
        paper.setRepresentativeItem(Items.field_151121_aF);
        paper.addTrait(writable2, HEAD);
        paper.addTrait(writable);
        sponge.setCraftable(true);
        sponge.addItem(Blocks.field_150360_v, 144);
        sponge.setRepresentativeItem(Blocks.field_150360_v);
        sponge.addTrait(squeaky);
        firewood.setCraftable(true);
        firewood.addItem(TinkerCommons.firewood, 1, 144);
        firewood.setRepresentativeItem(TinkerCommons.firewood);
        firewood.addTrait(autosmelt);
        slime.setCraftable(true);
        this.safeAdd(slime, TinkerCommons.matSlimeCrystalGreen, 144, true);
        slime.addTrait(slimeyGreen);
        blueslime.setCraftable(true);
        this.safeAdd(blueslime, TinkerCommons.matSlimeCrystalBlue, 144, true);
        blueslime.addTrait(slimeyBlue);
        knightslime.setCraftable(true);
        this.safeAdd(knightslime, TinkerCommons.ingotKnightSlime, 144, true);
        knightslime.addTrait(crumbling, HEAD);
        knightslime.addTrait(unnatural);
        magmaslime.setCraftable(true);
        this.safeAdd(magmaslime, TinkerCommons.matSlimeCrystalMagma, 144, true);
        magmaslime.addTrait(superheat, HEAD);
        magmaslime.addTrait(flammable);
        iron.addItem("ingotIron", 1, 144);
        iron.setRepresentativeItem(Items.field_151042_j);
        iron.addTrait(magnetic2, HEAD);
        iron.addTrait(magnetic);
        this.safeAdd(pigiron, TinkerCommons.ingotPigIron, 144, true);
        pigiron.addTrait(baconlicious, HEAD);
        pigiron.addTrait(tasty, HEAD);
        pigiron.addTrait(tasty);
        this.safeAdd(cobalt, TinkerCommons.ingotCobalt, 144, true);
        cobalt.addTrait(momentum, HEAD);
        cobalt.addTrait(lightweight);
        this.safeAdd(ardite, TinkerCommons.ingotArdite, 144, true);
        ardite.addTrait(stonebound, HEAD);
        ardite.addTrait(petramor);
        this.safeAdd(manyullyn, TinkerCommons.ingotManyullyn, 144, true);
        manyullyn.addTrait(insatiable, HEAD);
        manyullyn.addTrait(coldblooded);
        copper.addItem("ingotCopper", 1, 144);
        copper.addTrait(established);
        bronze.addItem("ingotBronze", 1, 144);
        bronze.addTrait(dense);
        lead.addItem("ingotLead", 1, 144);
        lead.addTrait(poisonous);
        silver.addItem("ingotSilver", 1, 144);
        silver.addTrait(holy);
        electrum.addItem("ingotElectrum", 1, 144);
        electrum.addTrait(shocking);
        steel.addItem("ingotSteel", 1, 144);
        steel.addTrait(sharp, HEAD);
        steel.addTrait(stiff);
        this.registerToolMaterials();
    }

    private void safeAdd(Material material, ItemStack item, int value) {
        this.safeAdd(material, item, value, false);
    }

    private void safeAdd(Material material, ItemStack item, int value, boolean representative) {
        if (item != null) {
            material.addItem(item, 1, value);
            if (representative) {
                material.setRepresentativeItem(item);
            }
        }
    }

    public void registerToolMaterials() {
        TinkerRegistry.addMaterialStats(wood, new HeadMaterialStats(35, 2.0f, 2.0f, 0), new HandleMaterialStats(1.0f, 25), new ExtraMaterialStats(15));
        TinkerRegistry.addMaterialStats(stone, new HeadMaterialStats(120, 4.0f, 2.9f, 1), new HandleMaterialStats(0.5f, -50), new ExtraMaterialStats(20));
        TinkerRegistry.addMaterialStats(flint, new HeadMaterialStats(150, 5.0f, 2.8f, 1), new HandleMaterialStats(0.6f, -60), new ExtraMaterialStats(40));
        TinkerRegistry.addMaterialStats(cactus, new HeadMaterialStats(210, 4.0f, 3.4f, 1), new HandleMaterialStats(0.85f, 20), new ExtraMaterialStats(50));
        TinkerRegistry.addMaterialStats(bone, new HeadMaterialStats(200, 5.09f, 2.5f, 1), new HandleMaterialStats(1.1f, 50), new ExtraMaterialStats(65));
        TinkerRegistry.addMaterialStats(obsidian, new HeadMaterialStats(89, 7.07f, 4.2f, 4), new HandleMaterialStats(0.9f, -150), new ExtraMaterialStats(90));
        TinkerRegistry.addMaterialStats(prismarine, new HeadMaterialStats(430, 5.5f, 6.0f, 1), new HandleMaterialStats(0.6f, -200), new ExtraMaterialStats(100));
        TinkerRegistry.addMaterialStats(endstone, new HeadMaterialStats(420, 3.23f, 3.23f, 3), new HandleMaterialStats(0.85f, 0), new ExtraMaterialStats(42));
        TinkerRegistry.addMaterialStats(paper, new HeadMaterialStats(12, 0.51f, 0.05f, 0), new HandleMaterialStats(0.1f, 5), new ExtraMaterialStats(5));
        TinkerRegistry.addMaterialStats(sponge, new HeadMaterialStats(550, 3.02f, 0.0f, 0), new HandleMaterialStats(1.2f, 250), new ExtraMaterialStats(250));
        TinkerRegistry.addMaterialStats(firewood, new HeadMaterialStats(550, 6.0f, 5.5f, 0), new HandleMaterialStats(1.0f, -200), new ExtraMaterialStats(150));
        TinkerRegistry.addMaterialStats(slime, new HeadMaterialStats(1000, 4.24f, 1.8f, 0), new HandleMaterialStats(0.7f, -100), new ExtraMaterialStats(350));
        TinkerRegistry.addMaterialStats(blueslime, new HeadMaterialStats(780, 4.03f, 1.8f, 0), new HandleMaterialStats(1.3f, -100), new ExtraMaterialStats(200));
        TinkerRegistry.addMaterialStats(knightslime, new HeadMaterialStats(850, 5.8f, 5.1f, 3), new HandleMaterialStats(0.5f, 500), new ExtraMaterialStats(125));
        TinkerRegistry.addMaterialStats(magmaslime, new HeadMaterialStats(600, 2.1f, 7.0f, 0), new HandleMaterialStats(0.85f, -200), new ExtraMaterialStats(150));
        TinkerRegistry.addMaterialStats(netherrack, new HeadMaterialStats(270, 4.5f, 3.0f, 1), new HandleMaterialStats(0.85f, -150), new ExtraMaterialStats(75));
        TinkerRegistry.addMaterialStats(cobalt, new HeadMaterialStats(780, 12.0f, 4.1f, 4), new HandleMaterialStats(0.9f, 100), new ExtraMaterialStats(300));
        TinkerRegistry.addMaterialStats(ardite, new HeadMaterialStats(990, 3.5f, 3.6f, 4), new HandleMaterialStats(1.4f, -200), new ExtraMaterialStats(450));
        TinkerRegistry.addMaterialStats(manyullyn, new HeadMaterialStats(820, 7.02f, 8.72f, 4), new HandleMaterialStats(0.5f, 250), new ExtraMaterialStats(50));
        TinkerRegistry.addMaterialStats(iron, new HeadMaterialStats(204, 6.0f, 4.0f, 2), new HandleMaterialStats(0.85f, 60), new ExtraMaterialStats(50));
        TinkerRegistry.addMaterialStats(pigiron, new HeadMaterialStats(380, 6.2f, 4.5f, 3), new HandleMaterialStats(1.2f, -100), new ExtraMaterialStats(170));
        TinkerRegistry.addMaterialStats(copper, new HeadMaterialStats(210, 5.3f, 3.0f, 1), new HandleMaterialStats(1.05f, 30), new ExtraMaterialStats(100));
        TinkerRegistry.addMaterialStats(bronze, new HeadMaterialStats(430, 6.8f, 3.5f, 2), new HandleMaterialStats(1.1f, 70), new ExtraMaterialStats(80));
        TinkerRegistry.addMaterialStats(lead, new HeadMaterialStats(334, 5.25f, 3.5f, 1), new HandleMaterialStats(0.7f, -50), new ExtraMaterialStats(100));
        TinkerRegistry.addMaterialStats(silver, new HeadMaterialStats(250, 5.0f, 5.0f, 1), new HandleMaterialStats(0.95f, 50), new ExtraMaterialStats(150));
        TinkerRegistry.addMaterialStats(electrum, new HeadMaterialStats(50, 12.0f, 3.0f, 1), new HandleMaterialStats(1.1f, -25), new ExtraMaterialStats(250));
        TinkerRegistry.addMaterialStats(steel, new HeadMaterialStats(540, 7.0f, 6.0f, 3), new HandleMaterialStats(0.9f, 150), new ExtraMaterialStats(25));
    }

    public void registerBowMaterials() {
    }

    public void registerProjectileMaterials() {
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (TinkerTools.shard == null) {
            return;
        }
        for (Material material : TinkerRegistry.getAllMaterials()) {
            ItemStack shard = TinkerTools.shard.getItemstackWithMaterial(material);
            material.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(72, new ItemStack[]{shard}));
            if (material.getShard() == null) continue;
            material.setShard(shard);
        }
    }

    static {
        alien = new TraitAlien();
        aquadynamic = new TraitAquadynamic();
        aridiculous = new TraitAridiculous();
        autosmelt = new TraitAutosmelt();
        baconlicious = new TraitBaconlicious();
        cheap = new TraitCheap();
        cheapskate = new TraitCheapskate();
        coldblooded = new TraitColdblooded();
        crude = new TraitCrude(1);
        crude2 = new TraitCrude(2);
        crumbling = new TraitCrumbling();
        dense = new TraitDense();
        depthdigger = new TraitDepthdigger();
        duritos = new TraitDuritos();
        ecological = new TraitEcological();
        enderference = new TraitEnderference();
        established = new TraitEstablished();
        flammable = new TraitFlammable();
        fractured = new TraitBonusDamage("fractured", 1.5f);
        hellish = new TraitHellish();
        holy = new TraitHoly();
        insatiable = new TraitInsatiable();
        jagged = new TraitJagged();
        lightweight = new TraitLightweight();
        magnetic = new TraitMagnetic(1);
        magnetic2 = new TraitMagnetic(2);
        momentum = new TraitMomentum();
        petramor = new TraitPetramor();
        poisonous = new TraitPoisonous();
        prickly = new TraitPrickly();
        sharp = new TraitSharp();
        shocking = new TraitShocking();
        slimeyGreen = new TraitSlimey("green", EntitySlime.class);
        slimeyBlue = new TraitSlimey("blue", EntityBlueSlime.class);
        spiky = new TraitSpiky();
        splintering = new TraitSplintering();
        splinters = new TraitSplinters();
        squeaky = new TraitSqueaky();
        superheat = new TraitSuperheat();
        stiff = new TraitStiff();
        stonebound = new TraitStonebound();
        tasty = new TraitTasty();
        unnatural = new TraitUnnatural();
        writable = new TraitWritable(1);
        writable2 = new TraitWritable(2);
        xu = new Material("unstable", EnumChatFormatting.WHITE);
    }
}

