/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.multiblock;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;

public abstract class MultiblockCuboid
extends MultiblockDetection {
    public final boolean hasCeiling;
    public final boolean hasFloor;
    public final boolean hasFrame;

    public MultiblockCuboid(boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        this.hasCeiling = hasCeiling;
        this.hasFloor = hasFloor;
        this.hasFrame = hasFrame;
    }

    @Override
    public MultiblockDetection.MultiblockStructure detectMultiblock(World world, BlockPos center, int limit) {
        int height;
        ArrayList subBlocks = Lists.newArrayList();
        int masterY = center.func_177956_o();
        center = this.getOuterPos(world, center, EnumFacing.DOWN, limit + 1).func_177984_a();
        int[] edges = new int[4];
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            BlockPos pos = this.getOuterPos(world, center, direction, limit);
            edges[direction.func_176736_b()] = pos.func_177958_n() - center.func_177958_n() + (pos.func_177952_p() - center.func_177952_p());
        }
        int xd = edges[EnumFacing.SOUTH.func_176736_b()] - edges[EnumFacing.NORTH.func_176736_b()] - 1;
        int zd = edges[EnumFacing.EAST.func_176736_b()] - edges[EnumFacing.WEST.func_176736_b()] - 1;
        if (xd > limit || zd > limit) {
            return null;
        }
        if (this.hasFloor && !this.detectFloor(world, center.func_177977_b(), edges, subBlocks)) {
            return null;
        }
        for (height = 0; height <= limit && this.detectLayer(world, center.func_177981_b(height), height, edges, subBlocks); ++height) {
        }
        if (height < 1 + masterY - center.func_177956_o()) {
            return null;
        }
        if (this.hasCeiling && !this.detectCeiling(world, center.func_177981_b(height + 1), edges, subBlocks)) {
            return null;
        }
        return new MultiblockDetection.MultiblockStructure(xd, height, zd, subBlocks);
    }

    public boolean isFloorBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    public boolean isCeilingBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    public boolean isFrameBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    public boolean isWallBlock(World world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    protected boolean detectFloor(World world, BlockPos center, int[] edges, List<BlockPos> subBlocks) {
        return this.detectPlaneXZ(world, center, edges, false, subBlocks);
    }

    private boolean detectCeiling(World world, BlockPos center, int[] edges, List<BlockPos> subBlocks) {
        return this.detectPlaneXZ(world, center, edges, true, subBlocks);
    }

    protected boolean detectPlaneXZ(World world, BlockPos center, int[] edges, boolean ceiling, List<BlockPos> subBlocks) {
        BlockPos from = center.func_177982_a(edges[1], 0, edges[2]);
        BlockPos to = center.func_177982_a(edges[3], 0, edges[0]);
        LinkedList candidates = Lists.newLinkedList();
        if (this.hasFrame) {
            LinkedList frame = Lists.newLinkedList();
            for (int x = 0; x <= to.func_177958_n() - from.func_177958_n(); ++x) {
                frame.add(from.func_177982_a(x, 0, 0));
                frame.add(to.func_177982_a(-x, 0, 0));
            }
            for (int z = 1; z < to.func_177952_p() - from.func_177952_p(); ++z) {
                frame.add(from.func_177982_a(0, 0, z));
                frame.add(to.func_177982_a(0, 0, -z));
            }
            for (BlockPos pos : frame) {
                if (!this.isFrameBlock(world, pos)) {
                    return false;
                }
                candidates.add(pos);
            }
        }
        from = from.func_177982_a(1, 0, 1);
        to = to.func_177982_a(-1, 0, -1);
        BlockPos z = from;
        while (z.func_177952_p() <= to.func_177952_p()) {
            BlockPos x = z;
            while (x.func_177958_n() <= to.func_177958_n()) {
                if (ceiling && !this.isCeilingBlock(world, x)) {
                    return false;
                }
                if (!ceiling && !this.isFloorBlock(world, x)) {
                    return false;
                }
                candidates.add(x);
                x = x.func_177982_a(1, 0, 0);
            }
            z = z.func_177982_a(0, 0, 1);
        }
        subBlocks.addAll(candidates);
        return true;
    }

    protected boolean detectLayer(World world, BlockPos center, int layer, int[] edges, List<BlockPos> subBlocks) {
        BlockPos from = center.func_177982_a(edges[1], 0, edges[2]);
        BlockPos to = center.func_177982_a(edges[3], 0, edges[0]);
        LinkedList candidates = Lists.newLinkedList();
        if (this.hasFrame) {
            LinkedList frame = Lists.newLinkedList();
            frame.add(from);
            frame.add(to);
            frame.add(new BlockPos(to.func_177958_n(), from.func_177956_o(), from.func_177952_p()));
            frame.add(new BlockPos(from.func_177958_n(), from.func_177956_o(), to.func_177952_p()));
            for (BlockPos pos : frame) {
                if (!this.isFrameBlock(world, pos)) {
                    return false;
                }
                candidates.add(pos);
            }
        }
        LinkedList blocks = Lists.newLinkedList();
        for (int x = edges[1] + 1; x < edges[3]; ++x) {
            for (int z = edges[2] + 1; z < edges[0]; ++z) {
                candidates.add(center.func_177982_a(x, 0, z));
            }
        }
        for (BlockPos pos : blocks) {
            if (!this.isInnerBlock(world, pos)) {
                return false;
            }
            if (world.func_175623_d(pos)) continue;
            candidates.add(pos);
        }
        blocks = Lists.newLinkedList();
        for (int x = edges[1] + 1; x < edges[3]; ++x) {
            blocks.add(center.func_177982_a(x, 0, edges[2]));
            blocks.add(center.func_177982_a(x, 0, edges[0]));
        }
        for (int z = edges[2] + 1; z < edges[0]; ++z) {
            blocks.add(center.func_177982_a(edges[1], 0, z));
            blocks.add(center.func_177982_a(edges[3], 0, z));
        }
        for (BlockPos pos : blocks) {
            if (!this.isWallBlock(world, pos)) {
                return false;
            }
            candidates.add(pos);
        }
        subBlocks.addAll(candidates);
        return true;
    }
}

