/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import org.apache.commons.lang3.tuple.Triple;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeHandler;
import slimeknights.tconstruct.plugin.jei.CastingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.CastingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.CastingRecipeWrapper;
import slimeknights.tconstruct.plugin.jei.CraftingStationRecipeTransferInfo;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.TableRecipeHandler;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;

    public void onJeiHelpersAvailable(IJeiHelpers jeiHelpers) {
        JEIPlugin.jeiHelpers = jeiHelpers;
    }

    public void onItemRegistryAvailable(IItemRegistry itemRegistry) {
    }

    public void register(IModRegistry registry) {
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationRecipeTransferInfo());
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            CastingRecipeCategory castingCategory = new CastingRecipeCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{new SmeltingRecipeCategory(guiHelper), new AlloyRecipeCategory(guiHelper), castingCategory});
            registry.addRecipeHandlers(new IRecipeHandler[]{new TableRecipeHandler(), new SmeltingRecipeHandler(), new AlloyRecipeHandler(), new CastingRecipeHandler()});
            registry.addRecipes(TinkerRegistry.getAllMeltingRecipies());
            registry.addRecipes(TinkerRegistry.getAlloys());
            HashMap castDict = Maps.newHashMap();
            for (CastingRecipe recipe : TinkerRegistry.getAllTableCastingRecipes()) {
                if (recipe.cast != null && recipe.getResult() != null && recipe.getResult().func_77973_b() instanceof Cast) {
                    Triple output = Triple.of((Object)recipe.getResult().func_77973_b(), (Object)Cast.getPartFromTag(recipe.getResult()), (Object)recipe.getFluid().getFluid());
                    if (!castDict.containsKey(output)) {
                        LinkedList list = Lists.newLinkedList();
                        castDict.put(output, list);
                        registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(list, recipe, castingCategory.castingTable))));
                    }
                    ((List)castDict.get(output)).addAll(recipe.cast.getInputs());
                    continue;
                }
                registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(recipe, castingCategory.castingTable))));
            }
            for (CastingRecipe recipe : TinkerRegistry.getAllBasinCastingRecipes()) {
                registry.addRecipes((List)ImmutableList.of((Object)((Object)new CastingRecipeWrapper(recipe, castingCategory.castingBasin))));
            }
        }
    }

    @Deprecated
    public void onRecipeRegistryAvailable(IRecipeRegistry recipeRegistry) {
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

