/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TooltipBuilder {
    public static final String LOC_FreeModifiers = "tooltip.tool.modifiers";
    private final List<String> tips = Lists.newLinkedList();
    private final ItemStack stack;

    public TooltipBuilder(ItemStack stack) {
        this.stack = stack;
    }

    public List<String> getTooltip() {
        return this.tips;
    }

    public TooltipBuilder add(String text) {
        this.tips.add(text);
        return this;
    }

    public TooltipBuilder addDurability(boolean textIfBroken) {
        if (ToolHelper.isBroken(this.stack) && textIfBroken) {
            this.tips.add(String.format("%s: %s%s%s", Util.translate("stat.head.durability.name", new Object[0]), EnumChatFormatting.DARK_RED, EnumChatFormatting.BOLD, Util.translate("tooltip.tool.broken", new Object[0])));
        } else {
            this.tips.add(HeadMaterialStats.formatDurability(ToolHelper.getCurrentDurability(this.stack), ToolHelper.getDurabilityStat(this.stack)));
        }
        return this;
    }

    public TooltipBuilder addMiningSpeed() {
        this.tips.add(HeadMaterialStats.formatMiningSpeed(ToolHelper.getActualMiningSpeed(this.stack)));
        return this;
    }

    public TooltipBuilder addHarvestLevel() {
        this.tips.add(HeadMaterialStats.formatHarvestLevel(ToolHelper.getHarvestLevelStat(this.stack)));
        return this;
    }

    public TooltipBuilder addAttack() {
        float attack = ToolHelper.getActualDamage(this.stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.tips.add(HeadMaterialStats.formatAttack(attack));
        return this;
    }

    public TooltipBuilder addFreeModifiers() {
        this.tips.add(String.format("%s: %d", StatCollector.func_74838_a((String)LOC_FreeModifiers), ToolHelper.getFreeModifiers(this.stack)));
        return this;
    }

    public TooltipBuilder addModifierInfo() {
        NBTTagList tagList = TagUtil.getModifiersTagList(this.stack);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag(tag);
            IModifier modifier = TinkerRegistry.getModifier(data.identifier);
            if (modifier == null || modifier.isHidden()) continue;
            for (String string : modifier.getExtraInfo(this.stack, tag)) {
                if (string.isEmpty()) continue;
                this.tips.add(data.getColorString() + string);
            }
        }
        return this;
    }
}

