/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import java.awt.image.DirectColorModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class ExtraUtilityTexture
extends AbstractColoredTexture {
    boolean[] trans;
    boolean[] edge;

    public ExtraUtilityTexture(TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
    }

    public ExtraUtilityTexture(String baseTextureLocation, String spriteName) {
        super(baseTextureLocation, spriteName);
    }

    @Override
    protected void processData(int[][] data) {
        DirectColorModel color = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        this.edge = new boolean[this.field_130223_c * this.field_130224_d];
        this.trans = new boolean[this.field_130223_c * this.field_130224_d];
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                int c;
                if (x == 0 || y == 0 || x == this.field_130223_c - 1 || y == this.field_130224_d - 1) {
                    this.edge[this.coord((int)x, (int)y)] = true;
                }
                if ((c = data[0][this.coord(x, y)]) != 0 && color.getAlpha(c) >= 64) continue;
                this.trans[this.coord((int)x, (int)y)] = true;
                if (x > 0) {
                    this.edge[this.coord((int)(x - 1), (int)y)] = true;
                }
                if (y > 0) {
                    this.edge[this.coord((int)x, (int)(y - 1))] = true;
                }
                if (x < this.field_130223_c - 1) {
                    this.edge[this.coord((int)(x + 1), (int)y)] = true;
                }
                if (y >= this.field_130224_d - 1) continue;
                this.edge[this.coord((int)x, (int)(y + 1))] = true;
            }
        }
        super.processData(data);
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        if (!this.trans[pxCoord]) {
            if (this.edge[pxCoord]) {
                int y;
                int alpha = 255;
                int x = this.getX(pxCoord);
                int lum = 256 + (x * 16 / this.field_130223_c + (y = this.getY(pxCoord)) * 16 / this.field_130224_d - 16) * 6;
                if (lum >= 256) {
                    lum = 255 - (lum - 256);
                }
                int col = alpha << 24 | lum << 16 | lum << 8 | lum;
                return col;
            }
            return 0;
        }
        return pixel;
    }
}

