/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableMap;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;

public class BakedMaterialModel
extends IFlexibleBakedModel.Wrapper
implements ISmartItemModel,
IPerspectiveAwareModel {
    protected Map<String, IFlexibleBakedModel> parts = new THashMap(TinkerRegistry.getAllMaterials().size());
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

    public BakedMaterialModel(IFlexibleBakedModel base, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        super((IBakedModel)base, base.getFormat());
        this.transforms = transforms;
    }

    public void addMaterialModel(Material material, IFlexibleBakedModel model) {
        this.parts.put(material.identifier, model);
    }

    public IBakedModel handleItemState(ItemStack stack) {
        if (stack.func_77973_b() instanceof IMaterialItem) {
            String id = ((IMaterialItem)stack.func_77973_b()).getMaterialID(stack);
            return this.getModelByIdentifier(id);
        }
        return this;
    }

    public IFlexibleBakedModel getModelByIdentifier(String identifier) {
        IFlexibleBakedModel materialModel = this.parts.get(identifier);
        if (materialModel == null) {
            return this;
        }
        return materialModel;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

