package slimeknights.tconstruct.smeltery.inventory;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;

import java.util.List;

import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.tools.inventory.ContainerSideInventory;

public class ContainerSmeltery extends ContainerMultiModule<TileSmeltery> {

  protected ContainerSideInventory<TileSmeltery> sideInventory;

  protected int[] oldHeats;

  public ContainerSmeltery(InventoryPlayer inventoryPlayer, TileSmeltery tile) {
    super(tile);

    sideInventory = new ContainerSideInventory<TileSmeltery>(tile, tile, 0, 0, calcColumns());
    addSubContainer(sideInventory, true);

    addPlayerInventory(inventoryPlayer, 8, 84);

    oldHeats = new int[tile.func_70302_i_()];
  }

  public int calcColumns() {
    return 3;
  }

  @Override
  public void func_75132_a(ICrafting listener) {
    super.func_75132_a(listener);

    for(int i = 0; i < oldHeats.length; i++) {
      listener.func_71112_a(this, i, tile.getTemperature(i));
    }
  }

  @Override
  public void func_75142_b() {
    super.func_75142_b();

    // send changed heats
    for(int i = 0; i < oldHeats.length; i++) {
      int temp = tile.getTemperature(i);
      if(temp != oldHeats[i]) {
        oldHeats[i] = temp;
        for(ICrafting crafter : this.field_75149_d) {
          crafter.func_71112_a(this, i, temp);
        }
      }
    }
  }

  @Override
  public void func_75137_b(int id, int data) {
    // id = index of the melting progress to update
    // data = temperature

    tile.updateTemperatureFromPacket(id, data);
  }
}
