package slimeknights.tconstruct.tools.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

import java.util.List;

import io.netty.buffer.ByteBuf;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.tools.inventory.ContainerToolStation;

public class ToolStationTextPacket extends AbstractPacketThreadsafe {

  public String text;

  public ToolStationTextPacket() {
  }

  public ToolStationTextPacket(String text) {
    this.text = text;
  }

  @Override
  public void handleClientSafe(NetHandlerPlayClient netHandler) {
    Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
    if(container instanceof ContainerToolStation) {
      ((ContainerToolStation) container).setToolName(text);
    }
  }

  @Override
  public void handleServerSafe(NetHandlerPlayServer netHandler) {
    Container container = netHandler.field_147369_b.field_71070_bA;
    if(container instanceof ContainerToolStation) {
      ((ContainerToolStation) container).setToolName(text);

      // find all people who also have the same gui open and update them too
      WorldServer server = netHandler.field_147369_b.func_71121_q();
      for(EntityPlayer player : (List<EntityPlayer>)server.field_73010_i) {
        if(player.field_71070_bA instanceof ContainerToolStation) {
          if(((ContainerToolStation) container).sameGui((ContainerToolStation) player.field_71070_bA)) {
            // same gui, send him an update
            TinkerNetwork.sendTo(this, (EntityPlayerMP) player);
          }
        }
      }
    }
  }

  @Override
  public void fromBytes(ByteBuf buf) {
    text = ByteBufUtils.readUTF8String(buf);
  }

  @Override
  public void toBytes(ByteBuf buf) {
    ByteBufUtils.writeUTF8String(buf, text);
  }
}
