package slimeknights.tconstruct.smeltery.client.module;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

import java.util.List;

import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.tools.client.module.GuiSideInventory;

public class GuiSmelterySideinventory extends GuiSideInventory {

  public static final ResourceLocation SLOT_LOCATION = GuiSmeltery.BACKGROUND;

  protected final TileSmeltery smeltery;

  protected GuiElement progressBar = new GuiElementScalable(176, 150, 3, 16, 256, 256);
  protected GuiElement unprogressBar = new GuiElementScalable(179, 150, 3, 16);
  protected GuiElement uberHeatBar =  new GuiElementScalable(182, 150, 3, 16);
  protected GuiElement noMeltBar =  new GuiElementScalable(185, 150, 3, 16);

  public GuiSmelterySideinventory(GuiMultiModule parent, Container container, TileSmeltery smeltery, int slotCount, int columns) {
    super(parent, container, slotCount, columns, false, true);

    this.smeltery = smeltery;

    GuiElement.defaultTexH = 256;
    GuiElement.defaultTexW = 256;
    slot = new GuiElementScalable(0, 166, 22, 18);
    slotEmpty = new GuiElementScalable(22, 166, 22, 18);
    yOffset = 0;
  }

  @Override
  protected boolean shouldDrawName() {
    return false;
  }

  @Override
  protected void updateSlots() {
    // adjust for the heat bar
    xOffset += 4;
    super.updateSlots();
    xOffset -= 4;
  }

  @Override
  protected int drawSlots(int xPos, int yPos) {
    this.field_146297_k.func_110434_K().func_110577_a(SLOT_LOCATION);
    int ret = super.drawSlots(xPos, yPos);
    this.field_146297_k.func_110434_K().func_110577_a(GUI_INVENTORY);
    return ret;
  }

  @Override
  public void func_146979_b(int mouseX, int mouseY) {
    super.func_146979_b(mouseX, mouseY);

    this.field_146297_k.func_110434_K().func_110577_a(SLOT_LOCATION);
    RenderHelper.func_74518_a();

    String tooltipText = null;

    // draw the "heat" bars for each slot
    for(Slot slot : field_147002_h.field_75151_b) {
      if(slot.func_75216_d() && shouldDrawSlot(slot)) {
        float progress = smeltery.getMeltingProgress(slot.getSlotIndex());
        String tooltip = null;
        GuiElement bar = progressBar;

        if(Float.isNaN(progress)) {
          progress = 1f;
          bar = noMeltBar;
          tooltip = "gui.smeltery.progress.no_recipe";
        }
        else if(progress < 0) {
          bar = unprogressBar;
          progress = 1f;
          tooltip = "gui.smeltery.progress.no_heat";
        }
        else if((progress > 1f && progress < 2f) || progress == Float.POSITIVE_INFINITY) {
          progress = 1f;
        }
        else if(progress > 2f) {
          bar = uberHeatBar;
          progress = 1f;
          tooltip = "gui.smeltery.progress.no_space";
        }

        int height = 1 + Math.round(progress * (bar.h-1));
        int x = slot.field_75223_e - 10 + this.field_146999_f;
        int y = slot.field_75221_f + bar.h - height;

        if(tooltip != null &&
           x + field_147003_i <= mouseX && x + field_147003_i + bar.w >= mouseX &&
           y + field_147009_r <= mouseY && y + field_147009_r + bar.h >= mouseY) {
          tooltipText = tooltip;
        }

        GuiScreen.func_146110_a(x, y, bar.x, bar.y + bar.h - height, bar.w, height, bar.texW, bar.texH);
      }
    }

    if(tooltipText != null) {
      func_146283_a(this.field_146289_q.func_78271_c(Util.translate(tooltipText), 100), mouseX - field_147003_i, mouseY - field_147009_r);
    }
  }
}
