package slimeknights.tconstruct.gadgets.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

import io.netty.buffer.ByteBuf;
import slimeknights.tconstruct.gadgets.TinkerGadgets;

// exists solely to be distinguishable from the vanilla itemframe
// also because network handling requires us to recreate what vanilla does.. meh
public class EntityFancyItemFrame extends EntityItemFrame implements IEntityAdditionalSpawnData {

  private FrameType type;

  public EntityFancyItemFrame(World worldIn, BlockPos p_i45852_2_, EnumFacing p_i45852_3_, int meta) {
    this(worldIn, p_i45852_2_, p_i45852_3_, FrameType.fromMeta(meta));
  }

  public EntityFancyItemFrame(World worldIn, BlockPos p_i45852_2_, EnumFacing p_i45852_3_, FrameType type) {
    super(worldIn, p_i45852_2_, p_i45852_3_);
    this.type = type;
  }

  public EntityFancyItemFrame(World worldIn) {
    super(worldIn);
  }

  @Override
  public void func_146065_b(Entity entity, boolean dropFrame) {
    if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops"))
    {
      ItemStack itemstack = this.func_82335_i();

      if (entity instanceof EntityPlayer)
      {
        EntityPlayer entityplayer = (EntityPlayer)entity;

        if (entityplayer.field_71075_bZ.field_75098_d)
        {
          this.func_110131_b(itemstack);
          return;
        }
      }

      // drop frame
      if(dropFrame) {
        this.func_70099_a(new ItemStack(TinkerGadgets.fancyFrame, 1, type.ordinal()), 0.0F);
      }

      // drop item in frame
      if (itemstack != null)
      {
        itemstack = itemstack.func_77946_l();
        this.func_110131_b(itemstack);
        this.func_70099_a(itemstack, 0.0F);
      }
    }
  }

  @Override
  public String func_70005_c_() {
    if (this.func_145818_k_())
    {
      return this.func_95999_t();
    }

    ItemStack foo = new ItemStack(TinkerGadgets.fancyFrame, 1, type.ordinal());
    return foo.func_82833_r();
  }

  @Override
  public void func_70014_b(NBTTagCompound tagCompound) {
    int nr = type != null ? type.ordinal() : 0;
    tagCompound.func_74768_a("frame", nr);
    super.func_70014_b(tagCompound);
  }

  @Override
  public void func_70037_a(NBTTagCompound tagCompund) {
    int nr = tagCompund.func_74762_e("frame");
    type = FrameType.values()[nr % FrameType.values().length];

    super.func_70037_a(tagCompund);
  }

  @Override
  public void writeSpawnData(ByteBuf buffer) {
    buffer.writeShort(this.field_174860_b.func_176736_b());
    buffer.writeShort(type != null ? this.type.ordinal() : 0);
  }

  @Override
  public void readSpawnData(ByteBuf additionalData) {
    EnumFacing facing = EnumFacing.func_176731_b(additionalData.readShort());
    func_174859_a(facing);
    this.type = FrameType.values()[additionalData.readShort()];
  }

  public String getType() {
    if(type == null) {
      return FrameType.JEWEL.toString();
    }
    return type.toString();
  }

  public enum FrameType {
    JEWEL,
    ALUBRASS,
    COBALT,
    ARDITE,
    MANYULLYN,
    GOLD;

    public static FrameType fromMeta(int meta) {
      return FrameType.values()[meta % FrameType.values().length];
    }
  }
}
