package slimeknights.tconstruct.tools.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;

import java.util.List;

import io.netty.buffer.ByteBuf;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.client.GuiToolStation;
import slimeknights.tconstruct.tools.inventory.ContainerToolStation;

public class ToolStationSelectionPacket extends AbstractPacketThreadsafe {

  public ToolCore tool;
  public int activeSlots;

  public ToolStationSelectionPacket() {
  }

  public ToolStationSelectionPacket(ToolCore tool, int activeSlots) {
    this.tool = tool;
    this.activeSlots = activeSlots;
  }

  @Override
  public void handleClientSafe(NetHandlerPlayClient netHandler) {
    Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
    if(container instanceof ContainerToolStation) {
      ((ContainerToolStation) container).setToolSelection(tool, activeSlots);
      if(Minecraft.func_71410_x().field_71462_r instanceof GuiToolStation) {
        ((GuiToolStation) Minecraft.func_71410_x().field_71462_r).onToolSelectionPacket(this);
      }
    }
  }

  @Override
  public void handleServerSafe(NetHandlerPlayServer netHandler) {
    Container container = netHandler.field_147369_b.field_71070_bA;
    if(container instanceof ContainerToolStation) {
      ((ContainerToolStation) container).setToolSelection(tool, activeSlots);

      // find all people who also have the same gui open and update them too
      WorldServer server = netHandler.field_147369_b.func_71121_q();
      for(EntityPlayer player : (List<EntityPlayer>)server.field_73010_i) {
        if(player == netHandler.field_147369_b)
          continue;
        if(player.field_71070_bA instanceof ContainerToolStation) {
          if(((BaseContainer) container).sameGui((BaseContainer) player.field_71070_bA)) {
            ((ContainerToolStation) player.field_71070_bA).setToolSelection(tool, activeSlots);
            // same gui, send him an update
            TinkerNetwork.sendTo(this, (EntityPlayerMP) player);
          }
        }
      }
    }
  }

  @Override
  public void fromBytes(ByteBuf buf) {
    int id = buf.readShort();
    if(id > -1) {
      Item item = Item.func_150899_d(id);
      if(item instanceof ToolCore) {
        tool = (ToolCore) item;
      }
    }

    activeSlots = buf.readInt();
  }

  @Override
  public void toBytes(ByteBuf buf) {
    if(tool == null)
      buf.writeShort(-1);
    else
      buf.writeShort(Item.func_150891_b(tool));

    buf.writeInt(activeSlots);
  }
}
