package slimeknights.tconstruct.debug;

import com.google.common.eventbus.Subscribe;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

import org.apache.logging.log4j.Logger;

import java.util.Set;

import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;

@Pulse(id=TinkerDebug.PulseId, description = "Debug utilities", defaultEnable = false)
public class TinkerDebug {
  public static final String PulseId = "TinkerDebug";
  static final Logger log = Util.getLogger(PulseId);

  @Subscribe
  public void postInit(FMLPostInitializationEvent event) {
    if(event.getSide().isClient()) {
      ClientCommandHandler.instance.func_71560_a(new ReloadResources());
    }
  }

  @Subscribe
  public void serverStart(FMLServerStartingEvent event) {
    event.registerServerCommand(new DamageTool());

    if(event.getSide().isClient()) {
      ClientCommandHandler.instance.func_71560_a(new LocalizationCheckCommand());
      ClientCommandHandler.instance.func_71560_a(new DumpMaterialTest());
      ClientCommandHandler.instance.func_71560_a(new FindBestTool());
      ClientCommandHandler.instance.func_71560_a(new GetToolGrowth());
      ClientCommandHandler.instance.func_71560_a(new CompareVanilla());
    }

    sanityCheck();
  }

  public static void sanityCheck() {
    // check all modifiers if they can be applied
    for(IModifier modifier : TinkerRegistry.getAllModifiers()) {
      try {
        modifier.matches(new ItemStack[] {new ItemStack(Items.field_151055_y)});
        modifier.matches(new ItemStack[1]);
      } catch(Exception e) {
        log.error("Caught exception in modifier " + modifier.getIdentifier());
        log.error(e);
      }
    }

    // check all blocks if all metadatas are supported
    for(ResourceLocation identifier : (Set<ResourceLocation>) Block.field_149771_c.func_148742_b()) {
      // only our own stuff
      if(!identifier.func_110624_b().equals(Util.RESOURCE)) {
        continue;
      }

      Block block = (Block)Block.field_149771_c.func_82594_a(identifier);
      for(int i = 0; i < 16; i++) {
        block.func_176201_c(block.func_176203_a(i));
      }
    }

    // same for items
    for(ResourceLocation identifier : (Set<ResourceLocation>) Item.field_150901_e.func_148742_b()) {
      // only our own stuff
      if(!identifier.func_110624_b().equals(Util.RESOURCE)) {
        continue;
      }

      Item item = (Item) Item.field_150901_e.func_82594_a(identifier);
      for(int i = 0; i < 0x7FFF; i++) {
        item.func_77647_b(i);
      }
    }
  }
}
