/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.module;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.tools.client.module.GuiSideInventory;

public class GuiSmelterySideinventory
extends GuiSideInventory {
    public static final ResourceLocation SLOT_LOCATION = GuiSmeltery.BACKGROUND;
    protected final TileSmeltery smeltery;
    protected GuiElement progressBar = new GuiElementScalable(176, 150, 3, 16, 256, 256);
    protected GuiElement unprogressBar = new GuiElementScalable(179, 150, 3, 16);
    protected GuiElement uberHeatBar = new GuiElementScalable(182, 150, 3, 16);
    protected GuiElement noMeltBar = new GuiElementScalable(185, 150, 3, 16);

    public GuiSmelterySideinventory(GuiMultiModule parent, Container container, TileSmeltery smeltery, int slotCount, int columns) {
        super(parent, container, slotCount, columns, false, true);
        this.smeltery = smeltery;
        GuiElement.defaultTexH = 256;
        GuiElement.defaultTexW = 256;
        this.slot = new GuiElementScalable(0, 166, 22, 18);
        this.slotEmpty = new GuiElementScalable(22, 166, 22, 18);
        this.yOffset = 0;
    }

    @Override
    protected boolean shouldDrawName() {
        return false;
    }

    @Override
    protected void updateSlots() {
        this.xOffset += 4;
        super.updateSlots();
        this.xOffset -= 4;
    }

    @Override
    protected int drawSlots(int xPos, int yPos) {
        this.mc.getTextureManager().bindTexture(SLOT_LOCATION);
        int ret = super.drawSlots(xPos, yPos);
        this.mc.getTextureManager().bindTexture(GUI_INVENTORY);
        return ret;
    }

    @Override
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        this.mc.getTextureManager().bindTexture(SLOT_LOCATION);
        RenderHelper.disableStandardItemLighting();
        String tooltipText = null;
        for (Slot slot : this.inventorySlots.inventorySlots) {
            if (!slot.getHasStack() || !this.shouldDrawSlot(slot)) continue;
            float progress = this.smeltery.getMeltingProgress(slot.getSlotIndex());
            String tooltip = null;
            GuiElement bar = this.progressBar;
            if (Float.isNaN(progress)) {
                progress = 1.0f;
                bar = this.noMeltBar;
                tooltip = "gui.smeltery.progress.no_recipe";
            } else if (progress < 0.0f) {
                bar = this.unprogressBar;
                progress = 1.0f;
                tooltip = "gui.smeltery.progress.no_heat";
            } else if (progress > 1.0f && progress < 2.0f || progress == Float.POSITIVE_INFINITY) {
                progress = 1.0f;
            } else if (progress > 2.0f) {
                bar = this.uberHeatBar;
                progress = 1.0f;
                tooltip = "gui.smeltery.progress.no_space";
            }
            int height = 1 + Math.round(progress * (float)(bar.h - 1));
            int x = slot.xDisplayPosition - 10 + this.xSize;
            int y = slot.yDisplayPosition + bar.h - height;
            if (tooltip != null && x + this.guiLeft <= mouseX && x + this.guiLeft + bar.w >= mouseX && y + this.guiTop <= mouseY && y + this.guiTop + bar.h >= mouseY) {
                tooltipText = tooltip;
            }
            GuiScreen.drawModalRectWithCustomSizedTexture((int)x, (int)y, (float)bar.x, (float)(bar.y + bar.h - height), (int)bar.w, (int)height, (float)bar.texW, (float)bar.texH);
        }
        if (tooltipText != null) {
            this.drawHoveringText(this.fontRendererObj.listFormattedStringToWidth(Util.translate(tooltipText, new Object[0]), 100), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }
}

