/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.multiblock.IMasterLogic;
import slimeknights.mantle.multiblock.IServantLogic;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryController;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.events.TinkerSmelteryEvent;
import slimeknights.tconstruct.smeltery.inventory.ContainerSmeltery;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockSmeltery;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidUpdatePacket;
import slimeknights.tconstruct.smeltery.network.SmelteryFuelUpdatePacket;
import slimeknights.tconstruct.smeltery.network.SmelteryInventoryUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructure;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class TileSmeltery
extends TileHeatingStructure
implements IMasterLogic,
ITickable,
IInventoryGui,
ISmelteryTankHandler {
    public static final DamageSource smelteryDamage = new DamageSource("smeltery").setFireDamage();
    static final Logger log = Util.getLogger("Smeltery");
    protected static final int MAX_SIZE = 9;
    protected static final int CAPACITY_PER_BLOCK = 1152;
    protected static final int ALLOYING_PER_TICK = 10;
    public boolean active;
    public MultiblockDetection.MultiblockStructure info;
    public List<BlockPos> tanks;
    public BlockPos currentTank;
    public FluidStack currentFuel;
    public BlockPos minPos;
    public BlockPos maxPos;
    protected SmelteryTank liquids;
    protected MultiblockSmeltery multiblock = new MultiblockSmeltery(this);
    protected int tick;

    public TileSmeltery() {
        super("gui.smeltery.name", 0, 1);
        this.liquids = new SmelteryTank(this);
        this.tanks = Lists.newLinkedList();
    }

    public void update() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (!this.isActive()) {
            if (this.tick == 0) {
                this.checkSmelteryStructure();
            }
        } else {
            if (this.tick == 0) {
                this.interactWithEntitiesInside();
            }
            if (this.tick % 4 == 0) {
                this.heatItems();
                this.alloyAlloys();
            }
            if (this.needsFuel) {
                this.consumeFuel();
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    @Override
    protected void updateHeatRequired(int index) {
        MeltingRecipe melting;
        ItemStack stack = this.getStackInSlot(index);
        if (stack != null && (melting = TinkerRegistry.getMelting(stack)) != null) {
            this.setHeatRequiredForSlot(index, Math.max(5, melting.getUsableTemperature()));
            if (!this.hasFuel()) {
                this.consumeFuel();
            }
            return;
        }
        this.setHeatRequiredForSlot(index, 0);
    }

    @Override
    protected boolean onItemFinishedHeating(ItemStack stack, int slot) {
        MeltingRecipe recipe = TinkerRegistry.getMelting(stack);
        if (recipe == null) {
            return false;
        }
        TinkerSmelteryEvent.OnMelting event = TinkerSmelteryEvent.OnMelting.fireEvent(this, stack, recipe.output);
        int filled = this.liquids.fill(event.result, false);
        if (filled == event.result.amount) {
            this.liquids.fill(event.result, true);
            this.setInventorySlotContents(slot, null);
            return true;
        }
        this.itemTemperatures[slot] = this.itemTempRequired[slot] * 2 + 1;
        return false;
    }

    protected void interactWithEntitiesInside() {
        AxisAlignedBB bb = this.info.getBoundingBox().contract(1.0, 1.0, 1.0);
        List entities = this.worldObj.getEntitiesWithinAABB(Entity.class, bb);
        block0: for (Entity entity : entities) {
            if (entity instanceof EntityItem) {
                if (TinkerRegistry.getMelting(((EntityItem)entity).getEntityItem()) == null) continue;
                ItemStack stack = ((EntityItem)entity).getEntityItem();
                for (int i = 0; i < this.getSizeInventory(); ++i) {
                    if (!this.isStackInSlot(i)) {
                        ItemStack invStack = stack.copy();
                        --stack.stackSize;
                        invStack.stackSize = 1;
                        this.setInventorySlotContents(i, invStack);
                    }
                    if (stack.stackSize > 0) continue;
                    entity.setDead();
                    continue block0;
                }
                continue;
            }
            FluidStack fluid = TinkerRegistry.getMeltingForEntity(entity);
            if (fluid == null && entity instanceof EntityLivingBase && entity.isEntityAlive() && !entity.isDead) {
                fluid = new FluidStack((Fluid)TinkerFluids.blood, 10);
            }
            if (fluid == null || !entity.attackEntityFrom(smelteryDamage, 2.0f)) continue;
            this.liquids.fill(fluid, true);
        }
    }

    protected void alloyAlloys() {
        for (AlloyRecipe recipe : TinkerRegistry.getAlloys()) {
            int matched = recipe.matches(this.liquids.getFluids());
            if (matched > 10) {
                matched = 10;
            }
            while (matched > 0) {
                for (FluidStack liquid : recipe.getFluids()) {
                    FluidStack toDrain = liquid.copy();
                    FluidStack drained = this.liquids.drain(toDrain, true);
                    if (drained.isFluidEqual(toDrain) && drained.amount == toDrain.amount) continue;
                    log.error("Smeltery alloy creation drained incorrect amount: was %s:%d, should be %s:%d", new Object[]{drained.getUnlocalizedName(), drained.amount, toDrain.getUnlocalizedName(), toDrain.amount});
                }
                FluidStack toFill = recipe.getResult().copy();
                int filled = this.liquids.fill(toFill, true);
                if (filled != recipe.getResult().amount) {
                    log.error("Smeltery alloy creation filled incorrect amount: was %d, should be %d (%s)", new Object[]{filled, recipe.getResult().amount * matched, recipe.getResult().getUnlocalizedName()});
                }
                matched -= filled;
            }
        }
    }

    @Override
    protected void consumeFuel() {
        TileTank tank;
        FluidStack liquid;
        TileEntity te;
        if (this.hasFuel()) {
            return;
        }
        this.searchForFuel();
        if (this.currentTank != null && (te = this.worldObj.getTileEntity(this.currentTank)) instanceof TileTank && (liquid = (tank = (TileTank)te).getInternalTank().getFluid()) != null) {
            FluidStack in = liquid.copy();
            int bonusFuel = TinkerRegistry.consumeSmelteryFuel(in);
            int amount = liquid.amount - in.amount;
            FluidStack drained = tank.drain(null, amount, false);
            if (drained.amount == amount) {
                tank.drain(null, amount, true);
                this.currentFuel = drained.copy();
                this.addFuel(bonusFuel, drained.getFluid().getTemperature(drained) - 300);
                if (this.worldObj != null && !this.worldObj.isRemote) {
                    TinkerNetwork.sendToAll((AbstractPacket)new SmelteryFuelUpdatePacket(this.pos, this.currentTank, this.temperature, this.currentFuel));
                }
            }
        }
    }

    private void searchForFuel() {
        if (this.currentTank != null && this.hasFuel(this.currentTank, this.currentFuel)) {
            return;
        }
        for (BlockPos pos : this.tanks) {
            if (!this.hasFuel(pos, this.currentFuel)) continue;
            this.currentTank = pos;
            return;
        }
        for (BlockPos pos : this.tanks) {
            if (!this.hasFuel(pos, null)) continue;
            this.currentTank = pos;
            return;
        }
        this.currentTank = null;
    }

    private boolean hasFuel(BlockPos pos, FluidStack preference) {
        IFluidTank tank = this.getTankAt(pos);
        if (tank != null && tank.getFluidAmount() > 0 && TinkerRegistry.isSmelteryFuel(tank.getFluid())) {
            if (preference != null && tank.getFluid().isFluidEqual(preference)) {
                return true;
            }
            if (preference == null) {
                return true;
            }
        }
        return false;
    }

    private IFluidTank getTankAt(BlockPos pos) {
        TileEntity te = this.worldObj.getTileEntity(pos);
        if (te instanceof TileTank) {
            return ((TileTank)te).getInternalTank();
        }
        return null;
    }

    public void notifyChange(IServantLogic servant, BlockPos pos) {
        this.checkSmelteryStructure();
    }

    public void checkSmelteryStructure() {
        boolean wasActive = this.isActive();
        IBlockState state = this.worldObj.getBlockState(this.getPos());
        if (!(state.getBlock() instanceof BlockSmelteryController)) {
            this.active = false;
        } else {
            EnumFacing in = ((EnumFacing)state.getValue((IProperty)BlockSmelteryController.FACING)).getOpposite();
            MultiblockDetection.MultiblockStructure structure = this.multiblock.detectMultiblock(this.worldObj, this.getPos().offset(in), 9);
            if (structure == null) {
                this.active = false;
                this.updateSmelteryInfo(new MultiblockDetection.MultiblockStructure(0, 0, 0, Lists.newLinkedList()));
            } else {
                this.active = true;
                MultiblockDetection.assignMultiBlock(this.worldObj, this.getPos(), structure.blocks);
                this.updateSmelteryInfo(structure);
                if (wasActive) {
                    this.worldObj.markBlockForUpdate(this.pos);
                }
            }
        }
        if (wasActive != this.isActive()) {
            this.worldObj.markBlockForUpdate(this.pos);
            this.markDirty();
        }
    }

    protected void updateSmelteryInfo(MultiblockDetection.MultiblockStructure structure) {
        this.info = structure;
        if (this.info != null) {
            this.minPos = this.info.minPos.add(1, 1, 1);
            this.maxPos = this.info.maxPos.add(-1, 0, -1);
        } else {
            this.minPos = this.maxPos = this.pos;
        }
        this.tanks.clear();
        for (BlockPos pos : structure.blocks) {
            if (this.worldObj.getBlockState(pos).getBlock() != TinkerSmeltery.searedTank) continue;
            this.tanks.add(pos);
        }
        int inventorySize = structure.xd * structure.yd * structure.zd;
        if (this.getSizeInventory() > inventorySize) {
            for (int i = inventorySize; i < this.getSizeInventory(); ++i) {
                if (this.getStackInSlot(i) == null) continue;
                this.dropItem(this.getStackInSlot(i));
            }
        }
        this.liquids.setCapacity(inventorySize * 1152);
        this.resize(inventorySize);
    }

    private void dropItem(ItemStack stack) {
        EnumFacing direction = (EnumFacing)this.worldObj.getBlockState(this.pos).getValue((IProperty)BlockSmelteryController.FACING);
        BlockPos pos = this.getPos().offset(direction);
        EntityItem entityitem = new EntityItem(this.worldObj, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
        this.worldObj.spawnEntityInWorld((Entity)entityitem);
    }

    public SmelteryTank getTank() {
        return this.liquids;
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerSmeltery(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiSmeltery((ContainerSmeltery)this.createContainer(inventoryplayer, world, pos), this);
    }

    public float getMeltingProgress(int index) {
        if (index < 0 || index > this.getSizeInventory() - 1) {
            return -1.0f;
        }
        if (!this.canHeat(index)) {
            return -1.0f;
        }
        return this.getProgress(index);
    }

    @SideOnly(value=Side.CLIENT)
    public FuelInfo getFuelDisplay() {
        FuelInfo info = new FuelInfo();
        if (this.hasFuel()) {
            info.fluid = this.currentFuel.copy();
            info.fluid.amount = 0;
            info.heat = this.temperature;
            info.maxCap = this.currentFuel.amount;
        } else if (this.currentTank != null && this.hasFuel(this.currentTank, this.currentFuel)) {
            IFluidTank tank = this.getTankAt(this.currentTank);
            info.fluid = tank.getFluid().copy();
            info.heat = this.temperature;
            info.maxCap = tank.getCapacity();
        }
        for (BlockPos pos : this.tanks) {
            IFluidTank tank;
            if (pos == this.currentTank || (tank = this.getTankAt(pos)) == null || tank.getFluidAmount() <= 0) continue;
            if (info.fluid == null) {
                info.fluid = tank.getFluid().copy();
                info.heat = info.fluid.getFluid().getTemperature(info.fluid);
                info.maxCap = tank.getCapacity();
                continue;
            }
            if (!tank.getFluid().isFluidEqual(info.fluid)) continue;
            info.fluid.amount += tank.getFluidAmount();
            info.maxCap += tank.getCapacity();
        }
        return info;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.minPos == null || this.maxPos == null) {
            return super.getRenderBoundingBox();
        }
        return AxisAlignedBB.fromBounds((double)this.minPos.getX(), (double)this.minPos.getY(), (double)this.minPos.getZ(), (double)(this.maxPos.getX() + 1), (double)(this.maxPos.getY() + 1), (double)(this.maxPos.getZ() + 1));
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        if (this.worldObj != null && this.worldObj instanceof WorldServer && !this.worldObj.isRemote && !ItemStack.areItemStacksEqual((ItemStack)itemstack, (ItemStack)this.getStackInSlot(slot))) {
            TinkerNetwork.sendToClients((WorldServer)this.worldObj, this.pos, (AbstractPacket)new SmelteryInventoryUpdatePacket(itemstack, slot, this.pos));
        }
        super.setInventorySlotContents(slot, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTemperatureFromPacket(int index, int heat) {
        if (index < 0 || index > this.getSizeInventory() - 1) {
            return;
        }
        this.itemTemperatures[index] = heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.liquids.setFluids(fluids);
    }

    @Override
    public void onTankChanged(List<FluidStack> fluids, FluidStack changed) {
        if (this.worldObj != null && !this.worldObj.isRemote) {
            TinkerNetwork.sendToAll((AbstractPacket)new SmelteryFluidUpdatePacket(this.pos, fluids));
        }
    }

    public void validate() {
        super.validate();
        this.active = false;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        this.liquids.writeToNBT(compound);
        compound.setBoolean("active", this.active);
        compound.setTag("currentTank", (NBTBase)TagUtil.writePos(this.currentTank));
        NBTTagList tankList = new NBTTagList();
        for (BlockPos pos : this.tanks) {
            tankList.appendTag((NBTBase)TagUtil.writePos(pos));
        }
        compound.setTag("tanks", (NBTBase)tankList);
        NBTTagCompound fuelTag = new NBTTagCompound();
        if (this.currentFuel != null) {
            this.currentFuel.writeToNBT(fuelTag);
        }
        compound.setTag("currentFuel", (NBTBase)fuelTag);
        compound.setTag("minPos", (NBTBase)TagUtil.writePos(this.minPos));
        compound.setTag("maxPos", (NBTBase)TagUtil.writePos(this.maxPos));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.liquids.readFromNBT(compound);
        this.active = compound.getBoolean("active");
        NBTTagList tankList = compound.getTagList("tanks", 10);
        this.tanks.clear();
        for (int i = 0; i < tankList.tagCount(); ++i) {
            this.tanks.add(TagUtil.readPos(tankList.getCompoundTagAt(i)));
        }
        NBTTagCompound fuelTag = compound.getCompoundTag("currentFuel");
        this.currentFuel = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fuelTag);
        this.minPos = TagUtil.readPos(compound.getCompoundTag("minPos"));
        this.maxPos = TagUtil.readPos(compound.getCompoundTag("maxPos"));
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.getPos(), this.getBlockMetadata(), tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        boolean wasActive = this.active;
        this.readFromNBT(pkt.getNbtCompound());
        if (this.isActive() != wasActive) {
            this.worldObj.markBlockForUpdate(this.pos);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public static class FuelInfo {
        public int heat;
        public int maxCap;
        public FluidStack fluid;
    }
}

