/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.common.PlayerHelper;
import slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileDrain;

public class BlockSmelteryIO
extends BlockEnumSmeltery<IOType> {
    public static final PropertyEnum<IOType> TYPE = PropertyEnum.create((String)"type", IOType.class);
    public static PropertyDirection FACING = PropertyDirection.create((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockSmelteryIO() {
        super(TYPE, IOType.class);
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{TYPE, FACING});
    }

    public IBlockState getStateFromMeta(int meta) {
        int horIndex = meta >> 2 & 0xF;
        return this.getDefaultState().withProperty((IProperty)this.prop, (Comparable)((Object)this.fromMeta(meta))).withProperty((IProperty)FACING, (Comparable)EnumFacing.HORIZONTALS[horIndex]);
    }

    public int getMetaFromState(IBlockState state) {
        return ((IOType)((Object)state.getValue((IProperty)this.prop))).getMeta() | ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex() << 2;
    }

    public int damageDropped(IBlockState state) {
        return ((IOType)((Object)state.getValue((IProperty)this.prop))).getMeta();
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileDrain();
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing side = placer.getHorizontalFacing().getOpposite();
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)side);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.getTileEntity(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)te;
        side = side.getOpposite();
        ItemStack stack = player.getHeldItem();
        if (stack == null) {
            return false;
        }
        ItemStack result = FluidUtil.tryEmptyBucket((ItemStack)stack, (IFluidHandler)tank, (EnumFacing)side);
        if (result != null) {
            if (!player.capabilities.isCreativeMode) {
                player.inventory.decrStackSize(player.inventory.currentItem, 1);
                PlayerHelper.spawnItemAtPlayer(player, result);
            }
            return true;
        }
        ItemStack copy = stack.copy();
        if (FluidUtil.tryEmptyFluidContainerItem((ItemStack)stack, (IFluidHandler)tank, (EnumFacing)side, (EntityPlayer)player)) {
            if (player.capabilities.isCreativeMode) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, copy);
            }
            return true;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack) || stack.getItem() instanceof IFluidContainerItem;
    }

    public static enum IOType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        DRAIN;

        public final int meta = this.ordinal();

        public String getName() {
            return this.toString();
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

