/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class Modifier
extends RecipeMatchRegistry
implements IModifier {
    public static final String LOC_Name = "modifier.%s.name";
    public static final String LOC_Desc = "modifier.%s.desc";
    public static final String LOC_Extra = "modifier.%s.extra";
    protected static final Random random = new Random();
    public final String identifier;
    protected final List<ModifierAspect> aspects = Lists.newLinkedList();
    private static final AttributeModifier ANTI_KNOCKBACK_MOD = new AttributeModifier("Anti Modifier Knockback", 1.0, 0);

    public Modifier(String identifier) {
        this.identifier = Util.sanitizeLocalizationString(identifier);
        TinkerRegistry.registerModifier(this);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    protected void addAspects(ModifierAspect ... aspects) {
        this.aspects.addAll(Arrays.asList(aspects));
    }

    @Override
    public final boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
        for (ModifierAspect aspect : this.aspects) {
            if (aspect.canApply(stack, original)) continue;
            return false;
        }
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(stack);
        for (int i = 0; i < modifiers.tagCount(); ++i) {
            String id = modifiers.getStringTagAt(i);
            IModifier mod = TinkerRegistry.getModifier(id);
            if (mod == null || this.canApplyTogether(mod)) continue;
            throw new TinkerGuiException(Util.translateFormatted("gui.error.incompatible_modifiers", this.getLocalizedName(), mod.getLocalizedName()));
        }
        Iterator iterator = EnchantmentHelper.getEnchantments((ItemStack)stack).keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (this.canApplyTogether(Enchantment.getEnchantmentById((int)id))) continue;
            String enchName = StatCollector.translateToLocal((String)Enchantment.getEnchantmentById((int)id).getName());
            throw new TinkerGuiException(Util.translateFormatted("gui.error.incompatible_enchantments", this.getLocalizedName(), enchName));
        }
        return this.canApplyCustom(stack);
    }

    public boolean canApplyTogether(Enchantment enchantment) {
        return true;
    }

    public boolean canApplyTogether(IModifier otherModifier) {
        return true;
    }

    protected boolean canApplyCustom(ItemStack stack) throws TinkerGuiException {
        return true;
    }

    @Override
    public void updateNBT(NBTTagCompound modifierTag) {
    }

    @Override
    public void apply(ItemStack stack) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        this.apply(root);
        stack.setTagCompound(root);
    }

    @Override
    public void apply(NBTTagCompound root) {
        NBTTagList tagList;
        if (!TinkerUtil.hasModifier(root, this.getIdentifier())) {
            tagList = TagUtil.getBaseModifiersTagList(root);
            tagList.appendTag((NBTBase)new NBTTagString(this.getIdentifier()));
            TagUtil.setBaseModifiersTagList(root, tagList);
        }
        NBTTagCompound modifierTag = new NBTTagCompound();
        tagList = TagUtil.getModifiersTagList(root);
        int index = TinkerUtil.getIndexInList(tagList, this.identifier);
        if (index >= 0) {
            modifierTag = tagList.getCompoundTagAt(index);
        }
        for (ModifierAspect aspect : this.aspects) {
            aspect.updateNBT(root, modifierTag);
        }
        this.updateNBT(modifierTag);
        if (!modifierTag.hasNoTags()) {
            ModifierNBT data = ModifierNBT.readTag(modifierTag);
            if (!this.identifier.equals(data.identifier)) {
                data.identifier = this.identifier;
                data.write(modifierTag);
            }
        }
        if (index >= 0) {
            tagList.set(index, (NBTBase)modifierTag);
        } else {
            tagList.appendTag((NBTBase)modifierTag);
        }
        TagUtil.setModifiersTagList(root, tagList);
        this.applyEffect(root, modifierTag);
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        StringBuilder sb = new StringBuilder();
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        sb.append(this.getLocalizedName());
        if (data.level > 1) {
            sb.append(" ");
            sb.append(TinkerUtil.getRomanNumeral(data.level));
        }
        return sb.toString();
    }

    public String getLeveledTooltip(NBTTagCompound modifierTag, boolean detailed) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        String basic = this.getLocalizedName();
        if (data.level == 0) {
            return basic;
        }
        if (data.level > 1) {
            basic = basic + " " + TinkerUtil.getRomanNumeral(data.level);
        }
        for (int i = data.level; i > 1; --i) {
            if (!StatCollector.canTranslate((String)String.format(LOC_Name + i, this.getIdentifier()))) continue;
            basic = StatCollector.translateToLocal((String)String.format(LOC_Name + i, this.getIdentifier()));
            break;
        }
        if (detailed) {
            return basic + " " + data.extraInfo;
        }
        return basic;
    }

    @Override
    public String getLocalizedName() {
        return Util.translate(LOC_Name, this.getIdentifier());
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translate(LOC_Desc, this.getIdentifier());
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ImmutableList.of();
    }

    @Override
    public boolean hasTexturePerMaterial() {
        return false;
    }

    protected static boolean attackEntitySecondary(DamageSource source, float damage, Entity entity, boolean ignoreInvulv, boolean resetInvulv) {
        return Modifier.attackEntitySecondary(source, damage, entity, ignoreInvulv, resetInvulv, true);
    }

    protected static boolean attackEntitySecondary(DamageSource source, float damage, Entity entity, boolean ignoreInvulv, boolean resetInvulv, boolean noKnockback) {
        IAttributeInstance knockbackAttribute = null;
        float oldLastDamage = 0.0f;
        if (entity instanceof EntityLivingBase) {
            oldLastDamage = ((EntityLivingBase)entity).lastDamage;
            if (noKnockback) {
                knockbackAttribute = ((EntityLivingBase)entity).getEntityAttribute(SharedMonsterAttributes.knockbackResistance);
            }
        }
        if (knockbackAttribute != null) {
            knockbackAttribute.applyModifier(ANTI_KNOCKBACK_MOD);
        }
        if (ignoreInvulv) {
            entity.hurtResistantTime = 0;
        }
        boolean hit = entity.attackEntityFrom(source, damage);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).lastDamage += oldLastDamage;
        }
        if (hit && resetInvulv) {
            entity.hurtResistantTime = 0;
        }
        if (knockbackAttribute != null) {
            knockbackAttribute.removeModifier(ANTI_KNOCKBACK_MOD);
        }
        return hit;
    }
}

