package fuj1n.recmod.client.event;

import com.mojang.authlib.GameProfile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent.ElementType;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.List;

import fuj1n.recmod.RecMod;
import fuj1n.recmod.lib.IndexReference;

public class EventRenderGame extends Gui {

  private static final int INDICATOR_WIDTH = 8;
  private static final int INDICATOR_PADDING = 0;
  private static final int INDICATOR_TOTAL = INDICATOR_WIDTH * 2 + INDICATOR_PADDING * 2;

  private ResourceLocation indicatorsHigh = new ResourceLocation("recmod:textures/sheets/indicatorsx2.png");
  private ResourceLocation indicatorsLow = new ResourceLocation("recmod:textures/sheets/indicators.png");

  private GuiPlayerTabOverlay to;

  @SubscribeEvent
  public void preRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
    Minecraft mc = Minecraft.func_71410_x();
    ResourceLocation indicators = Minecraft.func_71375_t() ? indicatorsHigh : indicatorsLow;

    if(event.getType() == ElementType.PLAYER_LIST) {
      event.setCanceled(true);

      to = mc.field_71456_v.func_175181_h();

      renderPlayerList(event, mc, indicators);
    }
  }

  public void renderPlayerList(RenderGameOverlayEvent.Pre event, Minecraft mc, ResourceLocation indicators) {
    int width = event.getResolution().func_78326_a();
    Scoreboard scoreboardIn = mc.field_71441_e.func_96441_U();
    ScoreObjective scoreObjectiveIn = scoreboardIn.func_96539_a(0);

    NetHandlerPlayClient nethandlerplayclient = mc.field_71439_g.field_71174_a;
    List<NetworkPlayerInfo> list = GuiPlayerTabOverlay.field_175252_a.<NetworkPlayerInfo>sortedCopy(nethandlerplayclient.func_175106_d());

    int namePingGap = 0;
    int j = 0;

    for (NetworkPlayerInfo networkplayerinfo : list) {
      int nameWidth = mc.field_71466_p.func_78256_a(to.func_175243_a(networkplayerinfo));
      namePingGap = Math.max(namePingGap, nameWidth);

      if (scoreObjectiveIn != null && scoreObjectiveIn.func_178766_e() != IScoreCriteria.EnumRenderType.HEARTS) {
        nameWidth = mc.field_71466_p.func_78256_a(" " + scoreboardIn.func_96529_a(networkplayerinfo.func_178845_a().getName(), scoreObjectiveIn).func_96652_c());
        j = Math.max(j, nameWidth);
      }
    }

    list = list.subList(0, Math.min(list.size(), 80));
    int l3 = list.size();
    int i4 = l3;
    int userRows;

    for (userRows = 1; i4 > 20; i4 = (l3 + userRows - 1) / userRows) {
      ++userRows;
    }

    boolean flag = mc.func_71387_A() || mc.func_147114_u().func_147298_b().func_179292_f();
    int l;

    if (scoreObjectiveIn != null) {
      if (scoreObjectiveIn.func_178766_e() == IScoreCriteria.EnumRenderType.HEARTS) {
        l = 90;
      } else {
        l = j;
      }
    } else {
      l = 0;
    }

    int userWidth = Math.min(userRows * ((flag ? 9 : 0) + namePingGap + l + 13), width - 50) / userRows;
    int userX = width / 2 - (userWidth * userRows + (userRows - 1) * 5) / 2;
    int menuY = 10;
    int menuWidth = userWidth * userRows + (userRows - 1) * 5;
    List<String> list1 = null;
    List<String> list2 = null;

    if (to.field_175256_i != null) {
      list1 = mc.field_71466_p.func_78271_c(to.field_175256_i.func_150254_d(), width - 50);

      for (String s : list1) {
        menuWidth = Math.max(menuWidth, mc.field_71466_p.func_78256_a(s));
      }
    }

    if (to.field_175255_h != null) {
      list2 = mc.field_71466_p.func_78271_c(to.field_175255_h.func_150254_d(), width - 50);

      for (String s2 : list2) {
        menuWidth = Math.max(menuWidth, mc.field_71466_p.func_78256_a(s2));
      }
    }

    // Indicator space transforms
    userWidth += INDICATOR_TOTAL;
    userX -= INDICATOR_TOTAL * userRows / 2;
    menuWidth += INDICATOR_TOTAL * userRows;

    if (list1 != null) {
      func_73734_a(width / 2 - menuWidth / 2 - 1, menuY - 1, width / 2 + menuWidth / 2 + 1, menuY + list1.size() * mc.field_71466_p.field_78288_b, Integer.MIN_VALUE);

      for (String s3 : list1) {
        int i2 = mc.field_71466_p.func_78256_a(s3);
        mc.field_71466_p.func_175063_a(s3, (float) (width / 2 - i2 / 2), (float) menuY, -1);
        menuY += mc.field_71466_p.field_78288_b;
      }

      ++menuY;
    }

    func_73734_a(width / 2 - menuWidth / 2 - 1, menuY - 1, width / 2 + menuWidth / 2 + 1, menuY + i4 * 9, Integer.MIN_VALUE);

    for (int k4 = 0; k4 < l3; ++k4) {
      int l4 = k4 / i4;
      int i5 = k4 % i4;
      int j2 = userX + l4 * userWidth + l4 * 5;
      int k2 = menuY + i5 * 9;
      func_73734_a(j2, k2, j2 + userWidth, k2 + 8, 553648127);
      GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
      GlStateManager.func_179141_d();
      GlStateManager.func_179147_l();
      GlStateManager.func_179120_a(770, 771, 1, 0);

      if (k4 < list.size()) {
        NetworkPlayerInfo networkplayerinfo1 = (NetworkPlayerInfo) list.get(k4);
        String s1 = to.func_175243_a(networkplayerinfo1);
        GameProfile gameprofile = networkplayerinfo1.func_178845_a();

        if (flag) {
          EntityPlayer entityplayer = mc.field_71441_e.func_152378_a(gameprofile.getId());
          boolean flag1 = entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.CAPE) && (gameprofile.getName().equals("Dinnerbone") || gameprofile.getName().equals("Grumm"));
          mc.func_110434_K().func_110577_a(networkplayerinfo1.func_178837_g());
          int l2 = 8 + (flag1 ? 8 : 0);
          int i3 = 8 * (flag1 ? -1 : 1);
          Gui.func_152125_a(j2, k2, 8.0F, (float) l2, 8, i3, 8, 8, 64.0F, 64.0F);

          if (entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.HAT)) {
            int j3 = 8 + (flag1 ? 8 : 0);
            int k3 = 8 * (flag1 ? -1 : 1);
            Gui.func_152125_a(j2, k2, 40.0F, (float) j3, 8, k3, 8, 8, 64.0F, 64.0F);
          }

          j2 += 9;
        }

        if (networkplayerinfo1.func_178848_b() == WorldSettings.GameType.SPECTATOR) {
          s1 = TextFormatting.ITALIC + s1;
          mc.field_71466_p.func_175063_a(s1, (float) j2, (float) k2, -1862270977);
        } else {
          mc.field_71466_p.func_175063_a(s1, (float) j2, (float) k2, -1);
        }

        // Indicator rendering
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        mc.func_110434_K().func_110577_a(indicators);
        int indicatorRecIndex = RecMod.instance.isPlayerRecording(networkplayerinfo1.func_178845_a().getName()) ? IndexReference.ICON_RED_INDEX : IndexReference.ICON_GRAY_INDEX;
        int indicatorStrIndex = RecMod.instance.isPlayerStreaming(networkplayerinfo1.func_178845_a().getName()) ? IndexReference.ICON_GREEN_INDEX : IndexReference.ICON_GRAY_INDEX;
        if (indicatorRecIndex != IndexReference.ICON_DISABLE_INDEX)
          func_73729_b(j2 - (flag ? 9 : 0) + userWidth - INDICATOR_TOTAL + INDICATOR_PADDING, k2, indicatorRecIndex * 8, (int) Math.floor(indicatorRecIndex / 32) * 8 + IndexReference.RES_SSD, INDICATOR_WIDTH, INDICATOR_WIDTH);
        func_73729_b(j2 - (flag ? 9 : 0) + userWidth - INDICATOR_TOTAL + INDICATOR_PADDING * 2 + INDICATOR_WIDTH, k2, indicatorStrIndex * 8, (int) Math.floor(indicatorStrIndex / 32) * 8 + IndexReference.RES_SSD, INDICATOR_WIDTH, INDICATOR_WIDTH);

        if (scoreObjectiveIn != null && networkplayerinfo1.func_178848_b() != WorldSettings.GameType.SPECTATOR) {
          int k5 = j2 + namePingGap + 1;
          int l5 = k5 + l;

          if (l5 - k5 > 5) {
            to.func_175247_a(scoreObjectiveIn, k2, gameprofile.getName(), k5, l5, networkplayerinfo1);
          }
        }

        to.func_175245_a(userWidth - INDICATOR_TOTAL, j2 - (flag ? 9 : 0), k2, networkplayerinfo1);
      }
    }

    if (list2 != null) {
      menuY = menuY + i4 * 9 + 1;
      func_73734_a(width / 2 - menuWidth / 2 - 1, menuY - 1, width / 2 + menuWidth / 2 + 1, menuY + list2.size() * mc.field_71466_p.field_78288_b, Integer.MIN_VALUE);

      for (String s4 : list2) {
        int j5 = mc.field_71466_p.func_78256_a(s4);
        mc.field_71466_p.func_175063_a(s4, (float) (width / 2 - j5 / 2), (float) menuY, -1);
        menuY += mc.field_71466_p.field_78288_b;
      }
    }
  }

  @SubscribeEvent
  public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
    Minecraft mc = Minecraft.func_71410_x();
    ResourceLocation indicators = Minecraft.func_71375_t() ? indicatorsHigh : indicatorsLow;

    if(event.getType() == ElementType.ALL && RecMod.instance.showSelf && mc.field_71462_r == null) {
      int x;
      int y;
      switch (RecMod.instance.posMode) {
        case 0:
          x = 0;
          y = 0;
          break;
        case 1:
          x = event.getResolution().func_78326_a() - 32;
          y = 0;
          break;
        case 2:
          x = event.getResolution().func_78326_a() / 2 - 16;
          y = event.getResolution().func_78328_b() / 2 - 8;
          break;
        case 3:
          x = 0;
          y = event.getResolution().func_78328_b() - 16;
          break;
        case 4:
          x = event.getResolution().func_78326_a() - 32;
          y = event.getResolution().func_78328_b() - 16;
          break;
        case 5:
          x = event.getResolution().func_78326_a() / 2 - 16 + RecMod.instance.absX;
          y = event.getResolution().func_78328_b() / 2 - 8 + RecMod.instance.absY;
          break;
        default:
          x = event.getResolution().func_78326_a() - 32;
          y = 0;
      }

      int indicatorRecIndex = RecMod.instance.isPlayerRecording(mc.field_71439_g.func_70005_c_()) ? IndexReference.ICON_RED_INDEX : IndexReference.ICON_GRAY_INDEX;
      int indicatorStrIndex = RecMod.instance.isPlayerStreaming(mc.field_71439_g.func_70005_c_()) ? IndexReference.ICON_GREEN_INDEX : IndexReference.ICON_GRAY_INDEX;
      mc.func_110434_K().func_110577_a(indicators);
      func_73729_b(x, y, indicatorRecIndex * 16, (int) Math.floor(indicatorRecIndex / 16) * 16 + IndexReference.RES_SD, 16, 16);
      func_73729_b(x + 16, y, indicatorStrIndex * 16, (int) Math.floor(indicatorStrIndex / 16) * 16 + IndexReference.RES_SD, 16, 16);
    }
  }
}
