package fuj1n.recmod.client.event;

import fuj1n.recmod.RecMod;
import fuj1n.recmod.lib.IndexReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.IScoreObjectiveCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent.ElementType;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.Iterator;
import java.util.List;

public class EventRenderGame extends Gui
{

    private ResourceLocation indicatorsHigh = new ResourceLocation("recmod:textures/sheets/indicatorsx2.png");
    private ResourceLocation indicatorsLow = new ResourceLocation("recmod:textures/sheets/indicators.png");

    private GuiPlayerTabOverlay to;

    @SubscribeEvent
    public void preRenderGameOverlay (RenderGameOverlayEvent.Pre event)
    {
        if (event.type == ElementType.PLAYER_LIST)
        {
            event.setCanceled(true);
            renderGameOverlay(event);
        }
    }

    @SubscribeEvent
    public void renderGameOverlay (RenderGameOverlayEvent event)
    {
        Minecraft mc = Minecraft.func_71410_x();
        ResourceLocation indicators = mc.func_71375_t() ? indicatorsHigh : indicatorsLow;

        if (event.type == ElementType.PLAYER_LIST)
        {
            if (to == null)
            {
                to = Minecraft.func_71410_x().field_71456_v.func_175181_h();
            }

            int infooffset = 1;

            int width = event.resolution.func_78326_a();
            Scoreboard scoreboard = mc.field_71441_e.func_96441_U();
            ScoreObjective scoreobjective = mc.field_71441_e.func_96441_U().func_96539_a(0);

            NetHandlerPlayClient nethandlerplayclient = mc.field_71439_g.field_71174_a;
            List list = to.field_175252_a.sortedCopy(nethandlerplayclient.func_175106_d());
            int j = 0;
            int k = 0;
            Iterator iterator = list.iterator();
            int l;

            while (iterator.hasNext())
            {
                NetworkPlayerInfo networkplayerinfo = (NetworkPlayerInfo) iterator.next();
                l = mc.field_71466_p.func_78256_a(to.func_175243_a(networkplayerinfo));
                j = Math.max(j, l) + 24;
                k = Math.max(k, l);
            }

            list = list.subList(0, Math.min(list.size(), 80));
            int j3 = list.size();
            int k3 = j3;

            for (l = 1; k3 > 20; k3 = (j3 + l - 1) / l)
            {
                ++l;
            }

            boolean flag = mc.func_71387_A() || mc.func_147114_u().func_147298_b().func_179292_f();
            int i1;

            if (scoreobjective != null)
            {
                if (scoreobjective.func_178766_e() == IScoreObjectiveCriteria.EnumRenderType.HEARTS)
                {
                    i1 = 90;
                }
                else
                {
                    i1 = k;
                }
            }
            else
            {
                i1 = 0;
            }

            int j1 = Math.min(l * ((flag ? 9 : 0) + j + i1 + 13), width - 50) / l;
            int k1 = width / 2 - (j1 * l + (l - 1) * 5) / 2;
            int l1 = 10;
            int i2 = j1 * l + (l - 1) * 5;
            List list1 = null;
            List list2 = null;
            Iterator iterator1;
            String s;

            if (to.field_175256_i != null)
            {
                list1 = mc.field_71466_p.func_78271_c(to.field_175256_i.func_150254_d(), width - 50);

                for (iterator1 = list1.iterator(); iterator1.hasNext(); i2 = Math.max(i2, mc.field_71466_p.func_78256_a(s)))
                {
                    s = (String) iterator1.next();
                }
            }

            if (to.field_175255_h != null)
            {
                list2 = mc.field_71466_p.func_78271_c(to.field_175255_h.func_150254_d(), width - 50);

                for (iterator1 = list2.iterator(); iterator1.hasNext(); i2 = Math.max(i2, mc.field_71466_p.func_78256_a(s)))
                {
                    s = (String) iterator1.next();
                }
            }

            int j2;

            if (list1 != null)
            {
                func_73734_a(width / 2 - i2 / 2 - 1, l1 - 1, width / 2 + i2 / 2 + 1, l1 + list1.size() * mc.field_71466_p.field_78288_b, Integer.MIN_VALUE);

                for (iterator1 = list1.iterator(); iterator1.hasNext(); l1 += mc.field_71466_p.field_78288_b)
                {
                    s = (String) iterator1.next();
                    j2 = mc.field_71466_p.func_78256_a(s);
                    mc.field_71466_p.func_175063_a(s, (float) (width / 2 - j2 / 2), (float) l1, -1);
                }

                ++l1;
            }

            func_73734_a(width / 2 - i2 / 2 - 1, l1 - 1, width / 2 + i2 / 2 + 1, l1 + k3 * 9, Integer.MIN_VALUE);

            for (int l3 = 0; l3 < j3; ++l3)
            {
                int i4 = l3 / k3;
                j2 = l3 % k3;
                int k2 = k1 + i4 * j1 + i4 * 5;
                int l2 = l1 + j2 * 9;
                func_73734_a(k2, l2, k2 + j1, l2 + 8, 553648127);
                GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a(770, 771, 1, 0);

                if (l3 < list.size())
                {
                    NetworkPlayerInfo networkplayerinfo1 = (NetworkPlayerInfo) list.get(l3);
                    String s1 = to.func_175243_a(networkplayerinfo1);

                    if (flag)
                    {
                        mc.func_110434_K().func_110577_a(networkplayerinfo1.func_178837_g());
                        Gui.func_152125_a(k2, l2, 8.0F, 8.0F, 8, 8, 8, 8, 64.0F, 64.0F);
                        EntityPlayer entityplayer = mc.field_71441_e.func_152378_a(networkplayerinfo1.func_178845_a().getId());

                        if (entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.HAT))
                        {
                            Gui.func_152125_a(k2, l2, 40.0F, 8.0F, 8, 8, 8, 8, 64.0F, 64.0F);
                        }

                        k2 += 9;
                    }

                    if (networkplayerinfo1.func_178848_b() == WorldSettings.GameType.SPECTATOR)
                    {
                        s1 = EnumChatFormatting.ITALIC + s1;
                        mc.field_71466_p.func_175063_a(s1, (float) k2, (float) l2, -1862270977);
                    }
                    else
                    {
                        mc.field_71466_p.func_175063_a(s1, (float) k2, (float) l2, -1);
                    }

                    mc.func_110434_K().func_110577_a(indicators);
                    int indicatorRecIndex = RecMod.instance.isPlayerRecording(networkplayerinfo1.func_178845_a().getName()) ? IndexReference.ICON_RED_INDEX : IndexReference.ICON_GRAY_INDEX;
                    int indicatorStrIndex = RecMod.instance.isPlayerStreaming(networkplayerinfo1.func_178845_a().getName()) ? IndexReference.ICON_GREEN_INDEX : IndexReference.ICON_GRAY_INDEX;
                    func_73729_b(width / 2 + i2 / 2 + 1 - infooffset - 16, l2, indicatorRecIndex * 8, (int) Math.floor(indicatorRecIndex / 32) * 8 + IndexReference.RES_SSD, 8, 8);
                    func_73729_b(width / 2 + i2 / 2 + 1 - infooffset - 8, l2, indicatorStrIndex * 8, (int) Math.floor(indicatorStrIndex / 32) * 8 + IndexReference.RES_SSD, 8, 8);

                    if (scoreobjective != null && networkplayerinfo1.func_178848_b() != WorldSettings.GameType.SPECTATOR)
                    {
                        int j4 = k2 + j + 1;
                        int i3 = j4 + i1;

                        if (i3 - j4 > 5)
                        {
                            // Draw Scoreboard Values
                            to.func_175247_a(scoreobjective, l2, networkplayerinfo1.func_178845_a().getName(), j4 - 24, i3 - 24, networkplayerinfo1);
                        }
                    }

                    // Draw Player Ping
                    to.func_175245_a(j1, k2 - (flag ? 9 : 0) - 18, l2, networkplayerinfo1);
                }
            }

            if (list2 != null)
            {
                l1 += k3 * 9 + 1;
                func_73734_a(width / 2 - i2 / 2 - 1, l1 - 1, width / 2 + i2 / 2 + 1, l1 + list2.size() * mc.field_71466_p.field_78288_b, Integer.MIN_VALUE);
                func_73734_a(width / 2 - i2 / 2 - 1, l1 - 1, width / 2 + i2 / 2 + 1, l1 + list2.size() * mc.field_71466_p.field_78288_b, Integer.MIN_VALUE);

                for (iterator1 = list2.iterator(); iterator1.hasNext(); l1 += mc.field_71466_p.field_78288_b)
                {
                    s = (String) iterator1.next();
                    j2 = mc.field_71466_p.func_78256_a(s);
                    mc.field_71466_p.func_175063_a(s, (float) (width / 2 - j2 / 2), (float) l1, -1);
                }
            }
        }
        else if (event.type == ElementType.ALL && RecMod.instance.showSelf && mc.field_71462_r == null)
        {
            int x;
            int y;
            switch (RecMod.instance.posMode)
            {
            case 0:
                x = 0;
                y = 0;
                break;
            case 1:
                x = event.resolution.func_78326_a() - 32;
                y = 0;
                break;
            case 2:
                x = event.resolution.func_78326_a() / 2 - 16;
                y = event.resolution.func_78328_b() / 2 - 8;
                break;
            case 3:
                x = 0;
                y = event.resolution.func_78328_b() - 16;
                break;
            case 4:
                x = event.resolution.func_78326_a() - 32;
                y = event.resolution.func_78328_b() - 16;
                break;
            case 5:
                x = event.resolution.func_78326_a() / 2 - 16 + RecMod.instance.absX;
                y = event.resolution.func_78328_b() / 2 - 8 + RecMod.instance.absY;
                break;
            default:
                x = event.resolution.func_78326_a() - 32;
                y = 0;
            }

            int indicatorRecIndex = RecMod.instance.isPlayerRecording(mc.field_71439_g.func_70005_c_()) ? IndexReference.ICON_RED_INDEX : IndexReference.ICON_GRAY_INDEX;
            int indicatorStrIndex = RecMod.instance.isPlayerStreaming(mc.field_71439_g.func_70005_c_()) ? IndexReference.ICON_GREEN_INDEX : IndexReference.ICON_GRAY_INDEX;
            mc.func_110434_K().func_110577_a(indicators);
            func_73729_b(x, y, indicatorRecIndex * 16, (int) Math.floor(indicatorRecIndex / 16) * 16 + IndexReference.RES_SD, 16, 16);
            func_73729_b(x + 16, y, indicatorStrIndex * 16, (int) Math.floor(indicatorStrIndex / 16) * 16 + IndexReference.RES_SD, 16, 16);
        }
    }
}
