/*
 * Decompiled with CFR 0.152.
 */
package fuj1n.recmod;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import fuj1n.recmod.client.event.EventClientEntityLogin;
import fuj1n.recmod.client.event.EventClientTick;
import fuj1n.recmod.client.event.EventRenderGame;
import fuj1n.recmod.command.CommandRec;
import fuj1n.recmod.legacy.OldConfigConverter;
import fuj1n.recmod.network.GuiHandler;
import fuj1n.recmod.network.PlayerTracker;
import fuj1n.recmod.network.packet.PacketClientCommand;
import fuj1n.recmod.network.packet.PacketEndOfInitialTransmission;
import fuj1n.recmod.network.packet.PacketPipeline;
import fuj1n.recmod.network.packet.PacketRemovePlayer;
import fuj1n.recmod.network.packet.PacketUpdatePlayerStatus;
import java.io.File;
import java.util.HashMap;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(name="Recording Status Mod", version="v1.4.2.1", modid="fuj1n.recmod", acceptableRemoteVersions="*", canBeDeactivated=false)
public class RecMod {
    @Mod.Instance(value="fuj1n.recmod")
    public static RecMod instance;
    public static final PacketPipeline packetPipeline;
    private static HashMap<String, Boolean> recorders;
    private static HashMap<String, Boolean> streamers;
    public boolean showSelf = true;
    public boolean keepState = false;
    public boolean recState = false;
    public boolean strState = false;
    public boolean enableKeys = false;
    public int keyRec = 44;
    public int keyStr = 45;
    public boolean showSelfDef = false;
    public File configFile;
    public Configuration config;
    public boolean mapsDirty = false;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new PlayerTracker());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        OldConfigConverter.configFile = new File(event.getModConfigurationDirectory(), "recmod.ui");
        if (event.getSide() == Side.CLIENT) {
            this.configFile = event.getSuggestedConfigurationFile();
            if (OldConfigConverter.configFile.exists() && !this.configFile.exists()) {
                OldConfigConverter.convert();
                OldConfigConverter.configFile.delete();
            } else {
                if (OldConfigConverter.configFile.exists()) {
                    OldConfigConverter.configFile.delete();
                }
                this.instanciateConfig();
            }
            this.readFromFile();
            MinecraftForge.EVENT_BUS.register((Object)new EventRenderGame());
            FMLCommonHandler.instance().bus().register((Object)new EventClientEntityLogin());
            FMLCommonHandler.instance().bus().register((Object)new EventClientTick());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetPipeline.initialise();
        PacketPipeline pp = packetPipeline;
        pp.registerPacket(PacketUpdatePlayerStatus.class);
        pp.registerPacket(PacketRemovePlayer.class);
        pp.registerPacket(PacketClientCommand.class);
        pp.registerPacket(PacketEndOfInitialTransmission.class);
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        if (MinecraftServer.getServer() == null) {
            return;
        }
        this.clearMaps();
        ServerCommandManager handler = (ServerCommandManager)MinecraftServer.getServer().getCommandManager();
        handler.registerCommand((ICommand)new CommandRec());
    }

    public void updatePlayerInformation(String username, int type, boolean flag) {
        HashMap<String, Boolean> modifyMap = type == 0 ? recorders : streamers;
        modifyMap.put(username, flag);
    }

    public boolean isPlayerRecording(String username) {
        if (username == null) {
            return false;
        }
        return recorders.get(username) != null ? recorders.get(username) : false;
    }

    public boolean isPlayerStreaming(String username) {
        if (username == null) {
            return false;
        }
        return streamers.get(username) != null ? streamers.get(username) : false;
    }

    public void onUIStateChanged() {
        this.writeToFile();
    }

    public void instanciateConfig() {
        this.config = new Configuration(this.configFile, true);
    }

    public void readFromFile() {
        this.config.load();
        this.showSelfDef = this.config.getBoolean("Show bobber", "Interface", this.showSelfDef, "Whether the bobber will be made visible if the mod determines that you are playing multiplayer.");
        this.enableKeys = this.config.getBoolean("Enable keyboard", "Keyboard", this.enableKeys, "Whether the keyboard shortcuts are enabled.");
        this.keyRec = this.config.getInt("Record Key", "Keyboard", this.keyRec, -1338, 250, "The key that will toggle recording.");
        this.keyStr = this.config.getInt("Stream Key", "Keyboard", this.keyStr, -1338, 250, "The key that will toggle streaming.");
        this.keepState = this.config.getBoolean("Keep state", "General", this.keepState, "Whether the recording state is kept throughout the gaming session.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void writeToFile() {
        this.configFile.delete();
        this.readFromFile();
    }

    public void removeUnneededData(String username) {
        recorders.remove(username);
        streamers.remove(username);
    }

    public void clearMaps() {
        recorders.clear();
        streamers.clear();
    }

    public void sendDataToPlayer(EntityPlayer player) {
        int i;
        for (i = 0; i < recorders.size(); ++i) {
            this.sendPacket(player, recorders.keySet().toArray()[i].toString(), 0, Boolean.parseBoolean(recorders.values().toArray()[i].toString()));
        }
        for (i = 0; i < streamers.size(); ++i) {
            this.sendPacket(player, streamers.keySet().toArray()[i].toString(), 1, Boolean.parseBoolean(streamers.values().toArray()[i].toString()));
        }
        if (player instanceof EntityPlayerMP) {
            PacketEndOfInitialTransmission pckt = new PacketEndOfInitialTransmission();
            packetPipeline.sendTo(pckt, (EntityPlayerMP)player);
        }
    }

    public void sendPacket(EntityPlayer target, String player, int type, boolean flag) {
        if (target instanceof EntityPlayerMP) {
            PacketUpdatePlayerStatus pckt = new PacketUpdatePlayerStatus(player, type, flag);
            packetPipeline.sendTo(pckt, (EntityPlayerMP)target);
        }
    }

    static {
        packetPipeline = new PacketPipeline();
        recorders = new HashMap();
        streamers = new HashMap();
    }
}

