/*
 * Decompiled with CFR 0.152.
 */
package fuj1n.recmod;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import fuj1n.recmod.client.event.EventClientEntityLogin;
import fuj1n.recmod.client.event.EventRenderGame;
import fuj1n.recmod.client.keybind.KeyHandlerRecMod;
import fuj1n.recmod.command.CommandRec;
import fuj1n.recmod.network.GuiHandler;
import fuj1n.recmod.network.PlayerTracker;
import fuj1n.recmod.network.packet.PacketClientCommand;
import fuj1n.recmod.network.packet.PacketPipeline;
import fuj1n.recmod.network.packet.PacketRemovePlayer;
import fuj1n.recmod.network.packet.PacketUpdatePlayerStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="Recording Status Mod", version="v1.4", modid="fuj1n.recmod", acceptableRemoteVersions="*", canBeDeactivated=false)
public class RecMod {
    @Mod.Instance(value="fuj1n.recmod")
    public static RecMod instance;
    public static final PacketPipeline packetPipeline;
    private static HashMap<String, Boolean> recorders;
    private static HashMap<String, Boolean> streamers;
    public boolean showSelf = true;
    public boolean enableKeys = false;
    public int keyRec = 44;
    public int keyStr = 45;
    public String sheetLocation = "recmod:textures/sheets/indicators.png";
    public boolean showSelfDef = false;
    public File configFile;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTracker());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        this.configFile = new File(event.getModConfigurationDirectory(), "recmod.ui");
        if (event.getSide() == Side.CLIENT) {
            this.readFromFile();
            MinecraftForge.EVENT_BUS.register((Object)new EventRenderGame());
            FMLCommonHandler.instance().bus().register((Object)new EventClientEntityLogin());
            FMLCommonHandler.instance().bus().register((Object)new KeyHandlerRecMod());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetPipeline.initialise();
        PacketPipeline pp = packetPipeline;
        pp.registerPacket(PacketUpdatePlayerStatus.class);
        pp.registerPacket(PacketRemovePlayer.class);
        pp.registerPacket(PacketClientCommand.class);
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        recorders = new HashMap();
        streamers = new HashMap();
        ServerCommandManager handler = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        handler.func_71560_a((ICommand)new CommandRec());
    }

    public void updatePlayerInformation(String username, int type, boolean flag) {
        HashMap<String, Boolean> modifyMap = type == 0 ? recorders : streamers;
        modifyMap.put(username, flag);
    }

    public boolean isPlayerRecording(String username) {
        if (username == null) {
            return false;
        }
        return recorders.get(username) != null ? recorders.get(username) : false;
    }

    public boolean isPlayerStreaming(String username) {
        if (username == null) {
            return false;
        }
        return streamers.get(username) != null ? streamers.get(username) : false;
    }

    public void onUIStateChanged() {
        this.writeToFile();
    }

    public void onSheetChanged() {
        this.writeToFile();
    }

    public void readFromFile() {
        if (!this.configFile.exists()) {
            this.writeToFile();
            return;
        }
        try {
            BufferedReader b = new BufferedReader(new FileReader(this.configFile));
            String line1 = b.readLine();
            String line2 = b.readLine();
            String line3 = b.readLine();
            String line4 = b.readLine();
            String line5 = b.readLine();
            this.showSelfDef = this.convertToBoolean(line1, true);
            this.sheetLocation = line2 != null && !line2.equals("") ? line2 : this.sheetLocation;
            this.enableKeys = this.convertToBoolean(line3, false);
            this.keyRec = this.convertToInteger(line4, 44);
            this.keyStr = this.convertToInteger(line5, 45);
            b.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int convertToInteger(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public boolean convertToBoolean(String s, boolean def) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public void writeToFile() {
        this.configFile.delete();
        try {
            this.configFile.createNewFile();
            BufferedWriter b = new BufferedWriter(new FileWriter(this.configFile));
            b.write(Boolean.toString(this.showSelfDef));
            b.newLine();
            b.write(this.sheetLocation);
            b.newLine();
            b.write(Boolean.toString(this.enableKeys));
            b.newLine();
            b.write(Integer.toString(this.keyRec));
            b.newLine();
            b.write(Integer.toString(this.keyStr));
            b.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeUnneededData(String username) {
        recorders.remove(username);
        streamers.remove(username);
    }

    public void sendDataToPlayer(EntityPlayer player) {
        int i;
        for (i = 0; i < recorders.size(); ++i) {
            this.sendPacket(player, recorders.keySet().toArray()[i].toString(), 0, Boolean.parseBoolean(recorders.values().toArray()[i].toString()));
        }
        for (i = 0; i < streamers.size(); ++i) {
            this.sendPacket(player, streamers.keySet().toArray()[i].toString(), 1, Boolean.parseBoolean(streamers.values().toArray()[i].toString()));
        }
    }

    public void sendPacket(EntityPlayer target, String player, int type, boolean flag) {
        PacketUpdatePlayerStatus pckt = new PacketUpdatePlayerStatus(player, type, flag);
        if (target instanceof EntityPlayerMP) {
            packetPipeline.sendTo(pckt, (EntityPlayerMP)target);
        }
    }

    static {
        packetPipeline = new PacketPipeline();
        recorders = new HashMap();
        streamers = new HashMap();
    }
}

