/*
 * Decompiled with CFR 0.152.
 */
package fuj1n.recmod;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.relauncher.Side;
import fuj1n.recmod.client.event.EventClientEntityLogin;
import fuj1n.recmod.client.event.EventRenderGame;
import fuj1n.recmod.client.keybind.KeyHandlerRecMod;
import fuj1n.recmod.command.CommandRec;
import fuj1n.recmod.network.PlayerTracker;
import fuj1n.recmod.network.packet.PacketChangeUISettings;
import fuj1n.recmod.network.packet.PacketChangeUISheet;
import fuj1n.recmod.network.packet.PacketPipeline;
import fuj1n.recmod.network.packet.PacketRemovePlayer;
import fuj1n.recmod.network.packet.PacketUpdatePlayerStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="Recording Status Mod", version="v1.3.2", modid="fuj1n.recmod", acceptableRemoteVersions="*", canBeDeactivated=false)
public class RecMod {
    @Mod.Instance(value="fuj1n.recmod")
    public static RecMod instance;
    public static final PacketPipeline packetPipeline;
    private static HashMap<String, Boolean> recorders;
    private static HashMap<String, Boolean> streamers;
    public boolean showSelf = true;
    public boolean showUI = false;
    public String sheetLocation = "recmod:textures/sheets/indicators.png";
    public boolean showSelfDef = false;
    public File configFile;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTracker());
        this.configFile = new File(event.getModConfigurationDirectory(), "recmod.ui");
        if (event.getSide() == Side.CLIENT) {
            this.readFromFile();
            MinecraftForge.EVENT_BUS.register((Object)new EventRenderGame());
            MinecraftForge.EVENT_BUS.register((Object)new EventClientEntityLogin());
            KeyHandlerRecMod keyh = KeyHandlerRecMod.instantiateSelf();
            MinecraftForge.EVENT_BUS.register((Object)keyh);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetPipeline.initialise();
        PacketPipeline pp = packetPipeline;
        pp.registerPacket(PacketUpdatePlayerStatus.class);
        pp.registerPacket(PacketRemovePlayer.class);
        pp.registerPacket(PacketChangeUISettings.class);
        pp.registerPacket(PacketChangeUISheet.class);
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        recorders = new HashMap();
        streamers = new HashMap();
        ServerCommandManager handler = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        handler.func_71560_a((ICommand)new CommandRec());
    }

    public void updatePlayerInformation(String username, int type, boolean flag) {
        HashMap<String, Boolean> modifyMap = type == 0 ? recorders : streamers;
        modifyMap.put(username, flag);
    }

    public boolean isPlayerRecording(String username) {
        if (username == null) {
            return false;
        }
        return recorders.get(username) != null ? recorders.get(username) : false;
    }

    public boolean isPlayerStreaming(String username) {
        if (username == null) {
            return false;
        }
        return streamers.get(username) != null ? streamers.get(username) : false;
    }

    public void onUIStateChanged() {
        this.writeToFile();
    }

    public void onSheetChanged() {
        this.writeToFile();
    }

    public void readFromFile() {
        if (!this.configFile.exists()) {
            return;
        }
        try {
            BufferedReader b = new BufferedReader(new FileReader(this.configFile));
            String line1 = b.readLine();
            String line2 = b.readLine();
            String line3 = b.readLine();
            this.showSelfDef = this.convertToBoolean(line1);
            this.showUI = this.convertToBoolean(line2);
            this.sheetLocation = line3 != null && !line3.equals("") ? line3 : this.sheetLocation;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean convertToBoolean(String s) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void writeToFile() {
        this.configFile.delete();
        try {
            this.configFile.createNewFile();
            BufferedWriter b = new BufferedWriter(new FileWriter(this.configFile));
            b.write(Boolean.toString(this.showSelfDef));
            b.newLine();
            b.write(Boolean.toString(this.showUI));
            b.newLine();
            b.write(this.sheetLocation);
            b.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int calculateNumber() {
        ArrayList list = new ArrayList();
        return list.size();
    }

    public void removeUnneededData(String username) {
        recorders.remove(username);
        streamers.remove(username);
    }

    public void sendDataToPlayer(EntityPlayer player) {
        int i;
        for (i = 0; i < recorders.size(); ++i) {
            this.sendPacket(player, recorders.keySet().toArray()[i].toString(), 0, Boolean.parseBoolean(recorders.values().toArray()[i].toString()));
        }
        for (i = 0; i < streamers.size(); ++i) {
            this.sendPacket(player, streamers.keySet().toArray()[i].toString(), 1, Boolean.parseBoolean(streamers.values().toArray()[i].toString()));
        }
    }

    public void sendPacket(EntityPlayer target, String player, int type, boolean flag) {
        PacketUpdatePlayerStatus pckt = new PacketUpdatePlayerStatus(player, type, flag);
        if (target instanceof EntityPlayerMP) {
            System.out.println("target = MP");
            packetPipeline.sendTo(pckt, (EntityPlayerMP)target);
        } else {
            System.out.println("target != MP");
        }
    }

    static {
        packetPipeline = new PacketPipeline();
        recorders = new HashMap();
        streamers = new HashMap();
    }
}

