/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.IPlantable;

public class HopseedTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;

    public HopseedTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
    }

    public HopseedTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random random, World worldIn, BlockPos position) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        if (this.seekHeight && (position = this.findGround(worldIn, position)).func_177956_o() < 0) {
            return;
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            int l;
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 2;
                if (j == position.func_177956_o()) {
                    k = 1;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            Block block = iblockstate.func_177230_c();
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                                flag = false;
                                continue;
                            }
                            if (j <= position.func_177956_o()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (flag) {
                boolean isSoil;
                IBlockState state = worldIn.func_180495_p(position.func_177977_b());
                Block soil = state.func_177230_c();
                boolean bl = isSoil = soil != null && soil.canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling2);
                if (isSoil) {
                    soil.onPlantGrow(state, worldIn, position.func_177977_b(), position);
                    this.growLogs(worldIn, position);
                    this.growLeaves(worldIn, random, position, height);
                    for (l = 0; l < height; ++l) {
                        BlockPos blockpos = new BlockPos(position.func_177958_n(), position.func_177956_o() + l, position.func_177952_p());
                        if (worldIn.func_180495_p(blockpos).func_177230_c().isAir(worldIn.func_180495_p(blockpos), (IBlockAccess)worldIn, blockpos) || worldIn.func_180495_p(blockpos).func_177230_c().func_176196_c(worldIn, blockpos) || worldIn.func_180495_p(blockpos) == this.leaves) {
                            this.setBlockAndMetadata(worldIn, blockpos, this.leaves);
                        }
                        if (l >= height - 1) continue;
                        blockpos = new BlockPos(position.func_177958_n() + 1, position.func_177956_o() + l, position.func_177952_p());
                        if (worldIn.func_180495_p(blockpos).func_177230_c().isAir(worldIn.func_180495_p(blockpos), (IBlockAccess)worldIn, blockpos) || worldIn.func_180495_p(blockpos).func_177230_c().func_176196_c(worldIn, blockpos) || worldIn.func_180495_p(blockpos) == this.leaves) {
                            this.setBlockAndMetadata(worldIn, blockpos, this.leaves);
                        }
                        if (worldIn.func_180495_p(blockpos = new BlockPos(position.func_177958_n() + 1, position.func_177956_o() + l, position.func_177952_p() + 1)).func_177230_c().isAir(worldIn.func_180495_p(blockpos), (IBlockAccess)worldIn, blockpos) || worldIn.func_180495_p(blockpos).func_177230_c().func_176196_c(worldIn, blockpos) || worldIn.func_180495_p(blockpos) == this.leaves) {
                            this.setBlockAndMetadata(worldIn, blockpos, this.leaves);
                        }
                        if (!worldIn.func_180495_p(blockpos = new BlockPos(position.func_177958_n(), position.func_177956_o() + l, position.func_177952_p() + 1)).func_177230_c().isAir(worldIn.func_180495_p(blockpos), (IBlockAccess)worldIn, blockpos) && !worldIn.func_180495_p(blockpos).func_177230_c().func_176196_c(worldIn, blockpos) && worldIn.func_180495_p(blockpos) != this.leaves) continue;
                        this.setBlockAndMetadata(worldIn, blockpos, this.leaves);
                    }
                }
            }
        }
    }

    BlockPos findGround(World world, BlockPos pos) {
        boolean foundGround = false;
        int height = Config.seaLevel + 64;
        do {
            BlockPos position;
            Block underBlock;
            if ((underBlock = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), --height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && underBlock != Blocks.field_150349_c && height >= Config.seaLevel) continue;
            foundGround = true;
        } while (!foundGround);
        return new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
    }

    private void growLogs(World worldIn, BlockPos position) {
        this.setBlockAndMetadata(worldIn, position, this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 0, 0), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(0, 0, 1), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 0, 1), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(0, 1, 0), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 1, 0), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(0, 1, 1), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 1, 1), this.log);
    }

    protected void growLeaves(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 2 + height; y <= pos.func_177956_o() + height; ++y) {
            int subract = y - (pos.func_177956_o() + height);
            int subract2 = 3 - subract;
            for (int x = pos.func_177958_n() - subract2; x <= pos.func_177958_n() + subract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subract2; z <= pos.func_177952_p() + subract2; ++z) {
                    int mathZ = z - pos.func_177952_p();
                    BlockPos blockpos = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(blockpos);
                    if (mathX < 0 && mathZ < 0 && mathX * mathX + mathZ * mathZ > subract2 * subract2 || (mathX > 0 || mathZ > 0) && mathX * mathX + mathZ * mathZ > (subract2 + 1) * (subract2 + 1) || random.nextInt(4) == 0 && mathX * mathX + mathZ * mathZ > (subract2 - 1) * (subract2 - 1) || !state.func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    this.setBlockAndMetadata(world, blockpos, this.leaves);
                }
            }
        }
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState stateNew) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || block.func_176196_c(world, pos) || world.func_180495_p(pos) == this.leaves) {
            world.func_180501_a(pos, stateNew, 2);
        }
    }
}

