/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.overworld.block.saplings;

import com.progwml6.natura.Natura;
import com.progwml6.natura.library.NaturaRegistry;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.logs.BlockOverworldLog;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.overworld.OverworldTreeGenerator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import slimeknights.mantle.block.EnumBlock;

public class BlockOverworldSapling
extends BlockSapling {
    public static PropertyEnum<SaplingType> FOLIAGE = PropertyEnum.func_177709_a((String)"foliage", SaplingType.class);

    public BlockOverworldSapling() {
        this.func_149647_a((CreativeTabs)NaturaRegistry.tabWorld);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
    }

    public void func_149666_a(@Nonnull Item itemIn, CreativeTabs tab, @Nonnull List<ItemStack> list) {
        for (SaplingType type : SaplingType.values()) {
            list.add(new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FOLIAGE, field_176479_b, field_176480_a});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= SaplingType.values().length) {
            meta = 0;
        }
        SaplingType sapling = SaplingType.values()[meta];
        return this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)sapling));
    }

    public int func_176201_c(IBlockState state) {
        return ((SaplingType)((Object)state.func_177229_b(FOLIAGE))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_176200_f(IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        IBlockState iblockstate = world.func_180495_p(pos);
        int meta = iblockstate.func_177230_c().func_176201_c(iblockstate);
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public void func_176476_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BaseTreeGenerator gen = new BaseTreeGenerator();
        switch ((SaplingType)((Object)state.func_177229_b(FOLIAGE))) {
            case MAPLE: {
                IBlockState log = NaturaOverworld.overworldLog.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.MAPLE));
                IBlockState leaves = NaturaOverworld.overworldLeaves.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.MAPLE));
                gen = new OverworldTreeGenerator(4, 2, log, leaves);
                break;
            }
            case SILVERBELL: {
                IBlockState log = NaturaOverworld.overworldLog.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.SILVERBELL));
                IBlockState leaves = NaturaOverworld.overworldLeaves.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.SILVERBELL));
                gen = new OverworldTreeGenerator(4, 2, log, leaves);
                break;
            }
            case AMARANTH: {
                IBlockState log = NaturaOverworld.overworldLog.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.AMARANTH));
                IBlockState leaves = NaturaOverworld.overworldLeaves.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.AMARANTH));
                gen = new OverworldTreeGenerator(9, 8, log, leaves);
                break;
            }
            case TIGER: {
                IBlockState log = NaturaOverworld.overworldLog.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.TIGER));
                IBlockState leaves = NaturaOverworld.overworldLeaves.func_176223_P().func_177226_a(BlockOverworldLog.TYPE, (Comparable)((Object)BlockOverworldLog.LogType.TIGER));
                gen = new OverworldTreeGenerator(6, 4, log, leaves);
                break;
            }
            default: {
                Natura.log.warn("BlockOverworldLog Warning: Invalid sapling meta/foliage, " + state.func_177229_b(FOLIAGE) + ". Please report!");
            }
        }
        worldIn.func_175698_g(pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public static enum SaplingType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        MAPLE,
        SILVERBELL,
        AMARANTH,
        TIGER;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

