/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.BlockData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementStructure;
import slimeknights.mantle.client.gui.book.element.ElementText;

public class ContentStructure
extends PageContent {
    public String title;
    public String data;
    public int[] size;
    public BlockData[] structure;

    @Override
    public void load() {
        BookRepository repo = this.parent.source;
        if (this.data == null || this.data.isEmpty()) {
            return;
        }
        ResourceLocation location = repo.getResourceLocation(this.data);
        if (location != null && repo.resourceExists(location)) {
            ContentStructure structure = (ContentStructure)BookLoader.GSON.fromJson(repo.resourceToString(repo.getResource(location)), ContentStructure.class);
            structure.parent = this.parent;
            structure.load();
            this.size = structure.size;
            this.structure = structure.structure;
        }
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int y = 16;
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
        }
        if (this.size != null && this.size.length == 3 && this.structure != null && this.structure.length > 0) {
            list.add(new ElementStructure(0, y, GuiBook.PAGE_WIDTH, GuiBook.PAGE_HEIGHT - y - 10, this.size, this.structure));
        }
        list.add(new ElementText(0, GuiBook.PAGE_HEIGHT - 10, GuiBook.PAGE_WIDTH, 10, "WIP - Not Yet Implemented"));
    }
}

