/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.objectmapping.DefaultObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializerCollection;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import ninja.leaping.configurate.util.MapFactories;

public class ConfigurationOptions {
    private final Supplier<ConcurrentMap<Object, SimpleConfigurationNode>> mapSupplier;
    private final String header;
    private final TypeSerializerCollection serializers;
    private final ImmutableSet<Class<?>> acceptedTypes;
    private final ObjectMapperFactory objectMapperFactory;

    private ConfigurationOptions(Supplier<ConcurrentMap<Object, SimpleConfigurationNode>> mapSupplier, String header, TypeSerializerCollection serializers, Set<Class<?>> acceptedTypes, ObjectMapperFactory objectMapperFactory) {
        this.mapSupplier = mapSupplier;
        this.header = header;
        this.serializers = serializers;
        this.acceptedTypes = acceptedTypes == null ? null : ImmutableSet.copyOf(acceptedTypes);
        this.objectMapperFactory = objectMapperFactory;
    }

    public static ConfigurationOptions defaults() {
        return new ConfigurationOptions(MapFactories.<SimpleConfigurationNode>insertionOrdered(), null, TypeSerializers.getDefaultSerializers(), null, DefaultObjectMapperFactory.getInstance());
    }

    public Supplier<ConcurrentMap<Object, ? extends ConfigurationNode>> getMapFactory() {
        return this.mapSupplier;
    }

    public ConfigurationOptions setMapFactory(Supplier<ConcurrentMap<Object, ConfigurationNode>> factory) {
        Preconditions.checkNotNull(factory, "factory");
        return new ConfigurationOptions(factory, this.header, this.serializers, this.acceptedTypes, this.objectMapperFactory);
    }

    public String getHeader() {
        return this.header;
    }

    public ConfigurationOptions setHeader(String header) {
        return new ConfigurationOptions(this.mapSupplier, header, this.serializers, this.acceptedTypes, this.objectMapperFactory);
    }

    public TypeSerializerCollection getSerializers() {
        return this.serializers;
    }

    public ConfigurationOptions setSerializers(TypeSerializerCollection serializers) {
        return new ConfigurationOptions(this.mapSupplier, this.header, serializers, this.acceptedTypes, this.objectMapperFactory);
    }

    public ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    public ConfigurationOptions setObjectMapperFactory(ObjectMapperFactory factory) {
        Preconditions.checkNotNull(factory, "factory");
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, this.acceptedTypes, factory);
    }

    public boolean acceptsType(Class<?> type) {
        if (this.acceptedTypes == null) {
            return true;
        }
        if (this.acceptedTypes.contains(type)) {
            return true;
        }
        for (Class clazz : this.acceptedTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public ConfigurationOptions setAcceptedTypes(Set<Class<?>> acceptedTypes) {
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, acceptedTypes, this.objectMapperFactory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationOptions that = (ConfigurationOptions)o;
        return Objects.equal(this.mapSupplier, that.mapSupplier) && Objects.equal(this.header, that.header);
    }

    public int hashCode() {
        return Objects.hashCode(this.mapSupplier, this.header);
    }
}

