/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.client.gui.GuiWidget;

@SideOnly(value=Side.CLIENT)
public class GuiWidgetTabs
extends GuiWidget {
    private static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private final GuiElement[] tabActive = new GuiElement[3];
    private final GuiElement[] tab = new GuiElement[3];
    public ResourceLocation tabsResource = creativeInventoryTabs;
    public int yOffset = 4;
    public int spacing = 2;
    public int selected;
    public int highlighted;
    protected List<ItemStack> icons = Lists.newArrayList();
    private final GuiMultiModule parent;
    private boolean clicked = false;

    public GuiWidgetTabs(GuiMultiModule parent, GuiElement tabLeft, GuiElement tabCenter, GuiElement tabRight, GuiElement activeLeft, GuiElement activeCenter, GuiElement activeRight) {
        this.parent = parent;
        this.tab[0] = tabLeft;
        this.tab[1] = tabCenter;
        this.tab[2] = tabRight;
        this.tabActive[0] = activeLeft;
        this.tabActive[1] = activeCenter;
        this.tabActive[2] = activeRight;
        this.selected = 0;
    }

    public void addTab(ItemStack icon) {
        this.icons.add(icon);
    }

    public void clear() {
        this.selected = 0;
        this.icons.clear();
    }

    public void update(int mouseX, int mouseY) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        mouseX -= this.xPos;
        this.highlighted = -1;
        if ((mouseY -= this.yPos) >= 0 && mouseY <= this.tab[1].h) {
            int x = 0;
            for (int i = 0; i < this.icons.size(); ++i) {
                if (mouseX >= x && mouseX < x + this.tab[1].w) {
                    this.highlighted = i;
                    break;
                }
                x += this.tab[1].w;
                x += this.spacing;
            }
        }
        if (this.clicked) {
            if (mouseDown) {
                return;
            }
            this.clicked = false;
            return;
        }
        if (!mouseDown) {
            return;
        }
        this.clicked = true;
        if (this.highlighted > -1) {
            this.selected = this.highlighted;
        }
    }

    @Override
    public void draw() {
        int y = this.yPos + this.yOffset;
        for (int i = 0; i < this.icons.size(); ++i) {
            int x = this.xPos + i * this.tab[0].w;
            if (i > 0) {
                x += i * this.spacing;
            }
            GuiElement[] toDraw = i == this.selected ? this.tabActive : this.tab;
            GuiElement actualTab = i == 0 && x == this.parent.cornerX ? toDraw[0] : (x == this.parent.cornerX + this.parent.width ? toDraw[2] : toDraw[1]);
            Minecraft.getMinecraft().getTextureManager().bindTexture(this.tabsResource);
            actualTab.draw(x, y);
            ItemStack icon = this.icons.get(i);
            if (icon == null) continue;
            RenderHelper.enableGUIStandardItemLighting();
            this.drawItemStack(icon, x + (actualTab.w - 16) / 2, y + (actualTab.h - 16) / 2);
            RenderHelper.disableStandardItemLighting();
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        RenderItem itemRender = Minecraft.getMinecraft().getRenderItem();
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)32.0f);
        itemRender.zLevel = 200.0f;
        itemRender.renderItemAndEffectIntoGUI(stack, x, y);
        itemRender.zLevel = 0.0f;
    }
}

