/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.google.common.collect.ImmutableMap;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelHelper {
    public static final IModelState DEFAULT_ITEM_STATE;
    public static final IModelState DEFAULT_TOOL_STATE;
    public static final TRSRTransformation BLOCK_THIRD_PERSON_RIGHT;
    public static final TRSRTransformation BLOCK_THIRD_PERSON_LEFT;

    public static TextureAtlasSprite getTextureFromBlock(Block block, int meta) {
        IBlockState state = block.func_176203_a(meta);
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static TextureAtlasSprite getTextureFromBlockstate(IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static BakedQuad colorQuad(int color, BakedQuad quad) {
        ColorTransformer transformer = new ColorTransformer(color, quad.getFormat());
        quad.pipe((IVertexConsumer)transformer);
        return transformer.build();
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    static {
        ImmutableMap.Builder<ItemCameraTransforms.TransformType, TRSRTransformation> builder = ImmutableMap.builder();
        builder.put(ItemCameraTransforms.TransformType.GROUND, ModelHelper.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builder.put(ItemCameraTransforms.TransformType.HEAD, ModelHelper.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        builder.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ModelHelper.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f));
        builder.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ModelHelper.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f));
        builder.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ModelHelper.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        builder.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ModelHelper.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_ITEM_STATE = new SimpleModelState(builder.build());
        builder = ImmutableMap.builder();
        builder.put(ItemCameraTransforms.TransformType.GROUND, ModelHelper.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builder.put(ItemCameraTransforms.TransformType.HEAD, ModelHelper.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        builder.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ModelHelper.get(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        builder.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ModelHelper.get(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        builder.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ModelHelper.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        builder.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ModelHelper.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL_STATE = new SimpleModelState(builder.build());
        BLOCK_THIRD_PERSON_RIGHT = ModelHelper.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        BLOCK_THIRD_PERSON_LEFT = ModelHelper.get(0.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.4f);
    }

    private static class ColorTransformer
    extends VertexTransformer {
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public ColorTransformer(int color, VertexFormat format) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            int a = color >> 24;
            if (a == 0) {
                a = 255;
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            this.r = (float)r / 255.0f;
            this.g = (float)g / 255.0f;
            this.b = (float)b / 255.0f;
            this.a = (float)a / 255.0f;
        }

        public void put(int element, float ... data) {
            VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (usage == VertexFormatElement.EnumUsage.COLOR && data.length >= 4) {
                data[0] = this.r;
                data[1] = this.g;
                data[2] = this.b;
                data[3] = this.a;
            }
            super.put(element, data);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }
}

