/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.util.RecipeMatch;

public class RecipeMatchRegistry {
    protected final PriorityQueue<RecipeMatch> items = new PriorityQueue<RecipeMatch>(1, RecipeComparator.INSTANCE);

    public RecipeMatch.Match matches(Collection<ItemStack> stacks) {
        return this.matches(stacks.toArray(new ItemStack[stacks.size()]));
    }

    public RecipeMatch.Match matches(ItemStack ... stacks) {
        for (RecipeMatch recipe : this.items) {
            RecipeMatch.Match match = recipe.matches(stacks);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public RecipeMatch.Match matches(ItemStack[] stacks, int minAmount) {
        int sum;
        RecipeMatch.Match match;
        stacks = RecipeMatchRegistry.copyItemStackArray(stacks);
        LinkedList matches = Lists.newLinkedList();
        for (sum = 0; sum < minAmount && (match = this.matches(stacks)) != null; sum += match.amount) {
            matches.add(match);
            RecipeMatch.removeMatch(stacks, match);
        }
        if (sum < minAmount) {
            return null;
        }
        LinkedList foundStacks = Lists.newLinkedList();
        for (RecipeMatch.Match m : matches) {
            foundStacks.addAll(m.stacks);
        }
        return new RecipeMatch.Match(foundStacks, sum);
    }

    public RecipeMatch.Match matchesRecursively(ItemStack[] stacks) {
        RecipeMatch.Match match;
        stacks = RecipeMatchRegistry.copyItemStackArray(stacks);
        LinkedList matches = Lists.newLinkedList();
        int sum = 0;
        while ((match = this.matches(stacks)) != null) {
            matches.add(match);
            RecipeMatch.removeMatch(stacks, match);
            sum += match.amount;
        }
        LinkedList foundStacks = Lists.newLinkedList();
        for (RecipeMatch.Match m : matches) {
            foundStacks.addAll(m.stacks);
        }
        return new RecipeMatch.Match(foundStacks, sum);
    }

    public void addItem(String oredictItem, int amountNeeded, int amountMatched) {
        this.items.add(new RecipeMatch.Oredict(oredictItem, amountNeeded, amountMatched));
    }

    public void addItem(String oredictItem) {
        this.addItem(oredictItem, 1, 1);
    }

    public void addItem(Block block, int amountMatched) {
        this.items.add(new RecipeMatch.Item(new ItemStack(block), 1, amountMatched));
    }

    public void addItem(Item item, int amountNeeded, int amountMatched) {
        this.items.add(new RecipeMatch.Item(new ItemStack(item), amountNeeded, amountMatched));
    }

    public void addItem(ItemStack item, int amountNeeded, int amountMatched) {
        this.items.add(new RecipeMatch.Item(item, amountNeeded, amountMatched));
    }

    public void addItem(Item item) {
        this.addItem(item, 1, 1);
    }

    public void addRecipeMatch(RecipeMatch match) {
        this.items.add(match);
    }

    public static ItemStack[] copyItemStackArray(ItemStack[] in) {
        ItemStack[] stacksCopy = new ItemStack[in.length];
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            stacksCopy[i] = in[i].func_77946_l();
        }
        return stacksCopy;
    }

    private static class RecipeComparator
    implements Comparator<RecipeMatch> {
        public static RecipeComparator INSTANCE = new RecipeComparator();

        private RecipeComparator() {
        }

        @Override
        public int compare(RecipeMatch o1, RecipeMatch o2) {
            return o2.amountMatched - o1.amountMatched;
        }
    }
}

