/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import slimeknights.mantle.block.BlockConnectedTexture;
import slimeknights.mantle.block.EnumBlock;

public class EnumBlockConnectedTexture<E extends Enum<E> & IStringSerializable>
extends EnumBlock<E> {
    public EnumBlockConnectedTexture(Material material, PropertyEnum<E> prop, Class<E> clazz) {
        super(material, prop, clazz);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)BlockConnectedTexture.CONNECTED_DOWN, (Comparable)Boolean.FALSE).withProperty((IProperty)BlockConnectedTexture.CONNECTED_EAST, (Comparable)Boolean.FALSE).withProperty((IProperty)BlockConnectedTexture.CONNECTED_NORTH, (Comparable)Boolean.FALSE).withProperty((IProperty)BlockConnectedTexture.CONNECTED_SOUTH, (Comparable)Boolean.FALSE).withProperty((IProperty)BlockConnectedTexture.CONNECTED_UP, (Comparable)Boolean.FALSE).withProperty((IProperty)BlockConnectedTexture.CONNECTED_WEST, (Comparable)Boolean.FALSE));
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos position) {
        return state.withProperty((IProperty)BlockConnectedTexture.CONNECTED_DOWN, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.DOWN))).withProperty((IProperty)BlockConnectedTexture.CONNECTED_EAST, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.EAST))).withProperty((IProperty)BlockConnectedTexture.CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.NORTH))).withProperty((IProperty)BlockConnectedTexture.CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.SOUTH))).withProperty((IProperty)BlockConnectedTexture.CONNECTED_UP, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.UP))).withProperty((IProperty)BlockConnectedTexture.CONNECTED_WEST, (Comparable)Boolean.valueOf(this.isSideConnectable(world, position, EnumFacing.WEST)));
    }

    @Override
    @Nonnull
    protected BlockStateContainer createBlockState() {
        if (this.prop == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{tmp, BlockConnectedTexture.CONNECTED_DOWN, BlockConnectedTexture.CONNECTED_UP, BlockConnectedTexture.CONNECTED_NORTH, BlockConnectedTexture.CONNECTED_SOUTH, BlockConnectedTexture.CONNECTED_WEST, BlockConnectedTexture.CONNECTED_EAST});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.prop, BlockConnectedTexture.CONNECTED_DOWN, BlockConnectedTexture.CONNECTED_UP, BlockConnectedTexture.CONNECTED_NORTH, BlockConnectedTexture.CONNECTED_SOUTH, BlockConnectedTexture.CONNECTED_WEST, BlockConnectedTexture.CONNECTED_EAST});
    }

    private boolean isSideConnectable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState original = world.getBlockState(pos);
        IBlockState connected = world.getBlockState(pos.offset(side));
        return original != null && connected != null && this.canConnect(original, connected);
    }

    protected boolean canConnect(IBlockState original, IBlockState connected) {
        return connected.getBlock() == original.getBlock() && connected.getValue((IProperty)this.prop) == original.getValue((IProperty)this.prop);
    }
}

