/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import gnu.trove.map.hash.TIntFloatHashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.item.ItemMetaDynamic;

public class ItemEdible
extends ItemFood {
    private ItemMetaDynamic dynamic;
    protected TIntIntHashMap foodLevels;
    protected TIntFloatHashMap saturations;
    protected TIntObjectHashMap<PotionEffect[]> potionEffects;
    protected BitSet alwaysEdible;
    public boolean displayEffectsTooltip;

    public ItemEdible() {
        super(0, 0.0f, false);
        this.setHasSubtypes(true);
        this.dynamic = new ItemMetaDynamic();
        this.foodLevels = new TIntIntHashMap();
        this.saturations = new TIntFloatHashMap();
        this.potionEffects = new TIntObjectHashMap();
        this.alwaysEdible = new BitSet();
        this.displayEffectsTooltip = true;
    }

    public ItemStack addFood(int meta, int food, float saturation, String name, PotionEffect ... effects) {
        return this.addFood(meta, food, saturation, name, effects.length > 0, effects);
    }

    public ItemStack addFood(int meta, int food, float saturation, String name, boolean alwaysEdible, PotionEffect ... effects) {
        this.dynamic.addMeta(meta, name);
        this.foodLevels.put(meta, food);
        this.saturations.put(meta, saturation);
        this.potionEffects.put(meta, (Object)effects);
        this.alwaysEdible.set(meta, alwaysEdible);
        return new ItemStack((Item)this, 1, meta);
    }

    public float getSaturationModifier(ItemStack stack) {
        return this.saturations.get(stack.getMetadata());
    }

    public int getHealAmount(ItemStack stack) {
        return this.foodLevels.get(stack.getMetadata());
    }

    protected void onFoodEaten(ItemStack stack, World worldIn, @Nonnull EntityPlayer player) {
        if (!worldIn.isRemote) {
            for (PotionEffect potion : (PotionEffect[])this.potionEffects.get(stack.getMetadata())) {
                player.addPotionEffect(new PotionEffect(potion.getPotion(), potion.getDuration(), potion.getAmplifier(), potion.getIsAmbient(), potion.doesShowParticles()));
            }
        }
    }

    @Nonnull
    public Item setUnlocalizedName(@Nonnull String unlocalizedName) {
        this.dynamic.setUnlocalizedName(unlocalizedName);
        return super.setUnlocalizedName(unlocalizedName);
    }

    @Nonnull
    public String getUnlocalizedName(ItemStack stack) {
        return this.dynamic.getUnlocalizedName(stack);
    }

    public int getMetadata(ItemStack stack) {
        return this.dynamic.getMetadata(stack);
    }

    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.dynamic.addInformation(stack, playerIn, tooltip, advanced);
        if (this.displayEffectsTooltip) {
            for (PotionEffect potionEffect : (PotionEffect[])this.potionEffects.get(stack.getMetadata())) {
                tooltip.add(I18n.translateToLocal((String)potionEffect.getEffectName()).trim());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.dynamic.getSubItems(itemIn, tab, subItems);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        this.dynamic.registerItemModels((Item)this);
    }

    @Nonnull
    public ActionResult<ItemStack> onItemRightClick(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        int meta = itemStackIn.getMetadata();
        if (this.dynamic.isValid(meta) && playerIn.canEat(this.alwaysEdible.get(itemStackIn.getMetadata()))) {
            playerIn.setActiveHand(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }
}

