/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.config;

import com.google.common.reflect.TypeToken;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;

public class BlockMeta {
    private static final BlockMeta MISSING = new BlockMeta(Blocks.AIR, 0);
    public static final transient TypeSerializer<BlockMeta> SERIALIZER = new TypeSerializer<BlockMeta>(){

        public BlockMeta deserialize(TypeToken<?> typeToken, ConfigurationNode configurationNode) throws ObjectMappingException {
            String val = configurationNode.getString();
            String[] parts = val.split(":");
            Block block = (Block)Block.REGISTRY.getObject((Object)new ResourceLocation(parts[0], parts[1]));
            if (block == Blocks.AIR) {
                return MISSING;
            }
            int meta = -1;
            if (parts.length > 2) {
                meta = Integer.valueOf(parts[2]);
            }
            return new BlockMeta(block, meta);
        }

        public void serialize(TypeToken<?> typeToken, BlockMeta blockMeta, ConfigurationNode configurationNode) throws ObjectMappingException {
            configurationNode.setValue((Object)blockMeta.toString());
        }
    };
    public Block block;
    public int metadata;

    public BlockMeta() {
    }

    public BlockMeta(Block block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public static BlockMeta of(IBlockState state) {
        return new BlockMeta(state.getBlock(), state.getBlock().getMetaFromState(state));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMeta blockMeta = (BlockMeta)o;
        if (this.metadata != blockMeta.metadata) {
            return false;
        }
        return this.block != null ? this.block.equals(blockMeta.block) : blockMeta.block == null;
    }

    public int hashCode() {
        int result = this.block != null ? this.block.hashCode() : 0;
        result = 31 * result + this.metadata;
        return result;
    }

    public String toString() {
        String val = this.block.getRegistryName().toString();
        if (this.metadata > -1) {
            val = val + ":" + this.metadata;
        }
        return val;
    }
}

