/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.stats.StatisticsManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.gui.book.GuiArrow;
import slimeknights.mantle.client.gui.book.GuiBookmark;
import slimeknights.mantle.client.gui.book.Textures;
import slimeknights.mantle.client.gui.book.element.BookElement;

@SideOnly(value=Side.CLIENT)
public class GuiBook
extends GuiScreen
implements IProgressMeter {
    public static boolean debug = false;
    public static final int TEX_SIZE = 512;
    public static int PAGE_MARGIN = 8;
    public static int PAGE_PADDING_TOP = 4;
    public static int PAGE_PADDING_BOT = 4;
    public static int PAGE_PADDING_LEFT = 8;
    public static int PAGE_PADDING_RIGHT = 0;
    public static float PAGE_SCALE = 1.0f;
    public static int PAGE_WIDTH_UNSCALED = 206;
    public static int PAGE_HEIGHT_UNSCALED = 200;
    public static int PAGE_WIDTH;
    public static int PAGE_HEIGHT;
    private boolean loadingAchievements = true;
    private GuiArrow previousArrow;
    private GuiArrow nextArrow;
    private GuiArrow backArrow;
    private GuiArrow indexArrow;
    public final BookData book;
    private ItemStack item;
    private int page = -1;
    private int oldPage = -2;
    private ArrayList<BookElement> leftElements = new ArrayList();
    private ArrayList<BookElement> rightElements = new ArrayList();
    public StatisticsManager statisticsManager;

    public static void init() {
        PAGE_WIDTH = (int)((float)(PAGE_WIDTH_UNSCALED - (PAGE_PADDING_LEFT + PAGE_PADDING_RIGHT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
        PAGE_HEIGHT = (int)((float)(PAGE_HEIGHT_UNSCALED - (PAGE_PADDING_TOP + PAGE_PADDING_BOT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
    }

    public GuiBook(BookData book, StatisticsManager statisticsManager, @Nullable ItemStack item) {
        this.book = book;
        this.item = item;
        this.statisticsManager = statisticsManager;
        this.mc = Minecraft.getMinecraft();
        this.fontRendererObj = this.mc.fontRendererObj;
        GuiBook.init();
    }

    public void drawerTransform(boolean rightSide) {
        if (rightSide) {
            GlStateManager.translate((float)(this.width / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN), (float)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        } else {
            GlStateManager.translate((float)(this.width / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN), (float)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        }
    }

    protected float leftOffset(boolean rightSide) {
        if (rightSide) {
            return this.width / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN;
        }
        return this.width / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN;
    }

    protected float topOffset() {
        return this.height / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN;
    }

    protected int getMouseX(boolean rightSide) {
        return (int)(((float)(Mouse.getX() * this.width / this.mc.displayWidth) - this.leftOffset(rightSide)) / PAGE_SCALE);
    }

    protected int getMouseY() {
        return (int)(((float)(this.height - Mouse.getY() * this.height / this.mc.displayHeight - 1) - this.topOffset()) / PAGE_SCALE);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GuiBook.init();
        FontRenderer fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = this.mc.fontRendererObj;
        }
        if (this.loadingAchievements) {
            this.drawDefaultBackground();
            this.drawCenteredString(this.fontRendererObj, I18n.format((String)"multiplayer.downloadingStats", (Object[])new Object[0]), this.width / 2, this.height / 2, 0xFFFFFF);
            this.drawCenteredString(this.fontRendererObj, LOADING_STRINGS[(int)(Minecraft.getSystemTime() / 150L % (long)LOADING_STRINGS.length)], this.width / 2, this.height / 2 + this.fontRendererObj.FONT_HEIGHT * 2, 0xFFFFFF);
            return;
        }
        if (debug) {
            GuiBook.drawRect((int)0, (int)0, (int)(fontRenderer.getStringWidth("DEBUG") + 4), (int)(fontRenderer.FONT_HEIGHT + 4), (int)0x55000000);
            fontRenderer.drawString("DEBUG", 2, 2, -1);
        }
        GlStateManager.enableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.pushMatrix();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
        float coverR = (float)(this.book.appearance.coverColor >> 16 & 0xFF) / 255.0f;
        float coverG = (float)(this.book.appearance.coverColor >> 8 & 0xFF) / 255.0f;
        float coverB = (float)(this.book.appearance.coverColor & 0xFF) / 255.0f;
        TextureManager render = this.mc.renderEngine;
        if (this.page == -1) {
            render.bindTexture(Textures.TEX_BOOKFRONT);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.color((float)coverR, (float)coverG, (float)coverB);
            GuiBook.drawModalRectWithCustomSizedTexture((int)(this.width / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.book.appearance.title.isEmpty()) {
                GuiBook.drawModalRectWithCustomSizedTexture((int)(this.width / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
                GlStateManager.pushMatrix();
                float scale = fontRenderer.getStringWidth(this.book.appearance.title) <= 67 ? 2.5f : 2.0f;
                GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
                fontRenderer.drawString(this.book.appearance.title, (float)(this.width / 2) / scale + 3.0f - (float)(fontRenderer.getStringWidth(this.book.appearance.title) / 2), (float)(this.height / 2 - fontRenderer.FONT_HEIGHT / 2) / scale - 4.0f, 11436032, true);
                GlStateManager.popMatrix();
            }
            if (!this.book.appearance.subtitle.isEmpty()) {
                GlStateManager.pushMatrix();
                GlStateManager.scale((float)1.5f, (float)1.5f, (float)1.0f);
                fontRenderer.drawString(this.book.appearance.subtitle, (float)(this.width / 2) / 1.5f + 7.0f - (float)(fontRenderer.getStringWidth(this.book.appearance.subtitle) / 2), (float)(this.height / 2 + 100 - fontRenderer.FONT_HEIGHT * 2) / 1.5f, 11436032, true);
                GlStateManager.popMatrix();
            }
        } else {
            BookElement element;
            int i;
            int mY;
            render.bindTexture(Textures.TEX_BOOK);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.color((float)coverR, (float)coverG, (float)coverB);
            GuiBook.drawModalRectWithCustomSizedTexture((int)(this.width / 2 - PAGE_WIDTH_UNSCALED), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)(PAGE_WIDTH_UNSCALED * 2), (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.page != 0) {
                GuiBook.drawModalRectWithCustomSizedTexture((int)(this.width / 2 - PAGE_WIDTH_UNSCALED), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
                GlStateManager.pushMatrix();
                this.drawerTransform(false);
                GlStateManager.scale((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 2 + "";
                    fontRenderer.drawString(pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.getStringWidth(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406, false);
                }
                int mX = this.getMouseX(false);
                mY = this.getMouseY();
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(mX, mY, partialTicks, fontRenderer);
                }
                GlStateManager.popMatrix();
            }
            render.bindTexture(Textures.TEX_BOOK);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.disableStandardItemLighting();
            if ((this.page < this.book.getFullPageCount(this.statisticsManager) - 1 || this.book.getPageCount(this.statisticsManager) % 2 != 0) && this.page < this.book.getFullPageCount(this.statisticsManager)) {
                GuiBook.drawModalRectWithCustomSizedTexture((int)(this.width / 2), (int)(this.height / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)PAGE_WIDTH_UNSCALED, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (float)512.0f, (float)512.0f);
                GlStateManager.pushMatrix();
                this.drawerTransform(true);
                GlStateManager.scale((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 3 + "";
                    fontRenderer.drawString(pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.getStringWidth(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406, false);
                }
                int mX = this.getMouseX(true);
                mY = this.getMouseY();
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(mX, mY, partialTicks, fontRenderer);
                }
                GlStateManager.popMatrix();
            }
        }
        super.drawScreen(mouseX, mouseY, partialTicks);
        GlStateManager.popMatrix();
    }

    public int openPage(int page) {
        return this.openPage(page, false);
    }

    public int openPage(int page, boolean returner) {
        if (this.loadingAchievements) {
            return -1;
        }
        if (page < 0) {
            return -1;
        }
        int bookPage = page == 1 ? 0 : (page % 2 == 0 ? (page - 1) / 2 + 1 : (page - 2) / 2 + 1);
        if (bookPage >= -1 && bookPage < this.book.getFullPageCount(this.statisticsManager)) {
            if (returner) {
                this.oldPage = this.page;
            }
            this._setPage(bookPage);
        }
        return page % 2 == 0 ? 0 : 1;
    }

    public void _setPage(int page) {
        this.page = page;
        this.buildPages();
    }

    public int getPage(int side) {
        if (this.page == 0 && side == 0) {
            return -1;
        }
        if (this.page == 0 && side == 1) {
            return 0;
        }
        if (side == 0) {
            return (this.page - 1) * 2 + 1;
        }
        if (side == 1) {
            return (this.page - 2) * 2 + 2;
        }
        return -1;
    }

    public int getPage_() {
        return this.page;
    }

    public ArrayList<BookElement> getElements(int side) {
        return side == 0 ? this.leftElements : (side == 1 ? this.rightElements : null);
    }

    public void openCover() {
        if (this.loadingAchievements) {
            return;
        }
        this._setPage(-1);
        this.leftElements.clear();
        this.rightElements.clear();
        this.buildPages();
    }

    public void itemClicked(ItemStack item) {
        StringActionProcessor.process(this.book.getItemAction(ItemStackData.getItemStackData(item, true)), this);
    }

    private void buildPages() {
        if (this.loadingAchievements) {
            return;
        }
        this.leftElements.clear();
        this.rightElements.clear();
        if (this.page == -1) {
            return;
        }
        if (this.page == 0) {
            PageData page = this.book.findPage(0, this.statisticsManager);
            if (page != null) {
                page.content.build(this.book, this.rightElements, false);
            }
        } else {
            PageData leftPage = this.book.findPage((this.page - 1) * 2 + 1, this.statisticsManager);
            PageData rightPage = this.book.findPage((this.page - 1) * 2 + 2, this.statisticsManager);
            if (leftPage != null) {
                leftPage.content.build(this.book, this.leftElements, false);
            }
            if (rightPage != null) {
                rightPage.content.build(this.book, this.rightElements, true);
            }
        }
        for (BookElement element : this.leftElements) {
            element.parent = this;
        }
        for (BookElement element : this.rightElements) {
            element.parent = this;
        }
    }

    public void initGui() {
        super.initGui();
        if (this.loadingAchievements) {
            this.mc.getConnection().sendPacket((Packet)new CPacketClientStatus(CPacketClientStatus.State.REQUEST_STATS));
            return;
        }
        this.previousArrow = new GuiArrow(0, -50, -50, GuiArrow.ArrowType.PREV, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.nextArrow = new GuiArrow(1, -50, -50, GuiArrow.ArrowType.NEXT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.backArrow = new GuiArrow(2, this.width / 2 - 9, this.height / 2 + 5 + PAGE_HEIGHT / 2, GuiArrow.ArrowType.LEFT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.indexArrow = new GuiArrow(3, this.width / 2 - PAGE_WIDTH_UNSCALED - 9, this.height / 2 - PAGE_HEIGHT_UNSCALED / 2, GuiArrow.ArrowType.BACK_UP, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover);
        this.buttonList.clear();
        this.buttonList.add(this.previousArrow);
        this.buttonList.add(this.nextArrow);
        this.buttonList.add(this.backArrow);
        this.buttonList.add(this.indexArrow);
        this.buildPages();
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.loadingAchievements) {
            return;
        }
        this.previousArrow.visible = this.page != -1;
        this.nextArrow.visible = this.page < this.book.getFullPageCount(this.statisticsManager) - (this.book.getPageCount(this.statisticsManager) % 2 != 0 ? 0 : 1);
        boolean bl = this.backArrow.visible = this.oldPage >= -1;
        if (this.page == -1) {
            this.nextArrow.xPosition = this.width / 2 + 80;
            this.indexArrow.visible = false;
        } else {
            this.previousArrow.xPosition = this.width / 2 - 184;
            this.nextArrow.xPosition = this.width / 2 + 165;
            this.indexArrow.visible = this.book.findSection("index") != null && (this.page - 1) * 2 + 2 > this.book.findSection("index").getPageCount();
        }
        this.previousArrow.yPosition = this.height / 2 + 75;
        this.nextArrow.yPosition = this.height / 2 + 75;
    }

    public void doneLoading() {
        this.loadingAchievements = false;
        this.initGui();
        this.openPage(this.book.findPageNumber(BookHelper.getSavedPage(this.item), this.statisticsManager));
    }

    public void actionPerformed(GuiButton button) {
        if (this.loadingAchievements) {
            return;
        }
        if (button instanceof GuiBookmark) {
            this.openPage(this.book.findPageNumber(((GuiBookmark)button).data.page, this.statisticsManager));
            return;
        }
        if (button == this.previousArrow) {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
        } else if (button == this.nextArrow) {
            ++this.page;
            if (this.page > this.book.getFullPageCount(this.statisticsManager) - (this.book.getPageCount(this.statisticsManager) % 2 != 0 ? 0 : 1)) {
                this.page = this.book.getFullPageCount(this.statisticsManager) - 1;
            }
        } else if (button == this.backArrow) {
            if (this.oldPage >= -1) {
                this.page = this.oldPage;
            }
        } else if (button == this.indexArrow) {
            this.openPage(this.book.findPageNumber("index.page1"));
        }
        this.oldPage = -2;
        this.buildPages();
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        super.keyTyped(typedChar, keyCode);
        if (this.loadingAchievements) {
            return;
        }
        switch (keyCode) {
            case 30: 
            case 203: {
                this.actionPerformed(this.previousArrow);
                break;
            }
            case 32: 
            case 205: {
                this.actionPerformed(this.nextArrow);
                break;
            }
            case 61: {
                debug = !debug;
            }
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.loadingAchievements) {
            return;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if ((float)mouseX > (float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int oldPage = this.page;
        ImmutableList elementList = ImmutableList.copyOf(right ? this.rightElements : this.leftElements);
        for (BookElement element : elementList) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.page == oldPage) continue;
            break;
        }
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        if (this.loadingAchievements) {
            return;
        }
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if ((float)mouseX > (float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseReleased(mouseX, mouseY, state);
            ++i;
        }
    }

    protected void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.loadingAchievements) {
            return;
        }
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if ((float)mouseX > (float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseClickMove(mouseX, mouseY, clickedMouseButton);
            ++i;
        }
    }

    public void onGuiClosed() {
        PageData page;
        if (this.loadingAchievements) {
            return;
        }
        if (this.mc.player == null) {
            return;
        }
        PageData pageData = page = this.page == 0 ? this.book.findPage(0, this.statisticsManager) : this.book.findPage((this.page - 1) * 2 + 1, this.statisticsManager);
        if (page == null) {
            page = this.book.findPage((this.page - 1) * 2 + 2, this.statisticsManager);
        }
        if (this.page == -1) {
            BookLoader.updateSavedPage((EntityPlayer)this.mc.player, this.item, "");
        } else if (page != null && page.parent != null) {
            BookLoader.updateSavedPage((EntityPlayer)this.mc.player, this.item, page.parent.name + "." + page.name);
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    static {
        GuiBook.init();
    }
}

