/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import slimeknights.mantle.util.SlimeknightException;

public abstract class BaseContainer<T extends TileEntity>
extends Container {
    protected double maxDist = 64.0;
    protected T tile;
    protected final Block originalBlock;
    protected final BlockPos pos;
    protected final World world;
    protected final IItemHandler itemHandler;
    public List<Container> subContainers = Lists.newArrayList();
    protected int playerInventoryStart = -1;

    public BaseContainer(T tile) {
        this(tile, null);
    }

    public BaseContainer(T tile, EnumFacing invDir) {
        this.tile = tile;
        this.itemHandler = tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, invDir) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, invDir) : new EmptyHandler();
        this.world = tile.getWorld();
        this.pos = tile.getPos();
        this.originalBlock = this.world.getBlockState(this.pos).getBlock();
    }

    public void syncOnOpen(EntityPlayerMP playerOpened) {
        WorldServer server = playerOpened.getServerWorld();
        for (EntityPlayer player : server.playerEntities) {
            if (player == playerOpened || !(player.openContainer instanceof BaseContainer) || !this.sameGui((BaseContainer)player.openContainer)) continue;
            this.syncWithOtherContainer((BaseContainer)player.openContainer, playerOpened);
            return;
        }
        this.syncNewContainer(playerOpened);
    }

    public T getTile() {
        return this.tile;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void syncWithOtherContainer(BaseContainer<T> otherContainer, EntityPlayerMP player) {
    }

    protected void syncNewContainer(EntityPlayerMP player) {
    }

    public boolean sameGui(BaseContainer otherContainer) {
        return this.tile == otherContainer.tile;
    }

    public boolean canInteractWith(@Nonnull EntityPlayer playerIn) {
        Block block = this.world.getBlockState(this.pos).getBlock();
        if (block == Blocks.AIR || block != this.originalBlock) {
            return false;
        }
        return playerIn.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= this.maxDist;
    }

    @Nonnull
    public List<ItemStack> getInventory() {
        return super.getInventory();
    }

    public String getInventoryDisplayName() {
        IInventory nameable = null;
        if (this.itemHandler instanceof InvWrapper && (nameable = ((InvWrapper)this.itemHandler).getInv()).getDisplayName() == null) {
            nameable = null;
        }
        if (nameable == null && this.tile instanceof IWorldNameable) {
            nameable = (IWorldNameable)this.tile;
        }
        if (nameable != null) {
            ITextComponent textName = nameable.getDisplayName();
            return textName != null ? textName.getFormattedText() : nameable.getName();
        }
        return null;
    }

    protected void addPlayerInventory(InventoryPlayer playerInventory, int xCorner, int yCorner) {
        int index = 9;
        int start = this.inventorySlots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlotToContainer(new Slot((IInventory)playerInventory, index, xCorner + col * 18, yCorner + row * 18));
                ++index;
            }
        }
        index = 0;
        for (int col = 0; col < 9; ++col) {
            this.addSlotToContainer(new Slot((IInventory)playerInventory, index, xCorner + col * 18, yCorner + 58));
            ++index;
        }
        this.playerInventoryStart = start;
    }

    @Nonnull
    protected Slot addSlotToContainer(Slot slotIn) {
        if (this.playerInventoryStart >= 0) {
            throw new SlimeknightException("BaseContainer: Player inventory has to be last slots. Add all slots before adding the player inventory.");
        }
        return super.addSlotToContainer(slotIn);
    }

    public ItemStack transferStackInSlot(EntityPlayer playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return null;
        }
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            int end = this.inventorySlots.size();
            if (index < this.playerInventoryStart ? !this.mergeItemStack(itemstack1, this.playerInventoryStart, end, true) : !this.mergeItemStack(itemstack1, 0, this.playerInventoryStart, false)) {
                return null;
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }

    protected boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (stack != null && stack.stackSize > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.stackSize <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (stack.stackSize > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.inventorySlots.get(k);
                ItemStack itemstack1 = slot.getStack();
                if (itemstack1 != null && itemstack1.getItem() == stack.getItem() && (!stack.getHasSubtypes() || stack.getMetadata() == itemstack1.getMetadata()) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack1) && this.canMergeSlot(stack, slot)) {
                    int l = itemstack1.stackSize + stack.stackSize;
                    int limit = Math.min(stack.getMaxStackSize(), slot.getItemStackLimit(stack));
                    if (l <= limit) {
                        stack.stackSize = 0;
                        itemstack1.stackSize = l;
                        slot.onSlotChanged();
                        flag1 = true;
                    } else if (itemstack1.stackSize < limit) {
                        stack.stackSize -= limit - itemstack1.stackSize;
                        itemstack1.stackSize = limit;
                        slot.onSlotChanged();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.stackSize <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.inventorySlots.get(k);
            ItemStack itemstack1 = slot.getStack();
            if (itemstack1 == null && slot.isItemValid(stack) && this.canMergeSlot(stack, slot)) {
                int limit = slot.getItemStackLimit(stack);
                ItemStack stack2 = stack.copy();
                if (stack2.stackSize > limit) {
                    stack2.stackSize = limit;
                    stack.stackSize -= limit;
                } else {
                    stack.stackSize = 0;
                }
                slot.putStack(stack2);
                slot.onSlotChanged();
                flag1 = true;
                if (stack.stackSize == 0) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }
}

