/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla;

import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeHandler;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeMaker;
import mezz.jei.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipesHandler;
import mezz.jei.plugins.vanilla.crafting.TippedArrowRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.TippedArrowRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FurnaceFuelCategory;
import mezz.jei.plugins.vanilla.furnace.FurnaceSmeltingCategory;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeMaker;
import mezz.jei.plugins.vanilla.ingredients.FluidStackHelper;
import mezz.jei.plugins.vanilla.ingredients.FluidStackListFactory;
import mezz.jei.plugins.vanilla.ingredients.FluidStackRenderer;
import mezz.jei.plugins.vanilla.ingredients.ItemStackHelper;
import mezz.jei.plugins.vanilla.ingredients.ItemStackListFactory;
import mezz.jei.plugins.vanilla.ingredients.ItemStackRenderer;
import mezz.jei.transfer.PlayerRecipeTransferHandler;
import mezz.jei.util.StackHelper;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fluids.FluidStack;

@JEIPlugin
public class VanillaPlugin
extends BlankModPlugin {
    @Override
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{Items.field_151134_bR});
        subtypeRegistry.registerSubtypeInterpreter(Items.field_185167_i, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter((Item)Items.field_151068_bn, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter((Item)Items.field_185155_bH, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter((Item)Items.field_185156_bI, PotionSubtypeInterpreter.INSTANCE);
        subtypeRegistry.registerSubtypeInterpreter(Items.field_179564_cE, new ISubtypeRegistry.ISubtypeInterpreter(){

            @Override
            @Nullable
            public String getSubtypeInfo(ItemStack itemStack) {
                EnumDyeColor baseColor = ItemBanner.func_179225_h((ItemStack)itemStack);
                return baseColor.toString();
            }
        });
        subtypeRegistry.registerSubtypeInterpreter(Items.field_151063_bx, new ISubtypeRegistry.ISubtypeInterpreter(){

            @Override
            @Nullable
            public String getSubtypeInfo(ItemStack itemStack) {
                return ItemMonsterPlacer.func_185080_h((ItemStack)itemStack);
            }
        });
    }

    @Override
    public void registerIngredients(IModIngredientRegistration ingredientRegistration) {
        StackHelper stackHelper = Internal.getStackHelper();
        ingredientRegistration.register(ItemStack.class, ItemStackListFactory.create(stackHelper), new ItemStackHelper(stackHelper), new ItemStackRenderer());
        ingredientRegistration.register(FluidStack.class, FluidStackListFactory.create(), new FluidStackHelper(), new FluidStackRenderer());
    }

    @Override
    public void register(IModRegistry registry) {
        IIngredientRegistry ingredientRegistry = registry.getIngredientRegistry();
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new CraftingRecipeCategory(guiHelper), new FurnaceFuelCategory(guiHelper), new FurnaceSmeltingCategory(guiHelper), new BrewingRecipeCategory(guiHelper));
        registry.addRecipeHandlers(new ShapedOreRecipeHandler(jeiHelpers), new ShapedRecipesHandler(), new ShapelessOreRecipeHandler(jeiHelpers), new ShapelessRecipesHandler(guiHelper), new TippedArrowRecipeHandler(), new FuelRecipeHandler(), new SmeltingRecipeHandler(), new BrewingRecipeHandler());
        registry.addRecipeClickArea(GuiCrafting.class, 88, 32, 28, 23, "minecraft.crafting");
        registry.addRecipeClickArea(GuiInventory.class, 137, 29, 10, 13, "minecraft.crafting");
        registry.addRecipeClickArea(GuiBrewingStand.class, 97, 16, 14, 30, "minecraft.brewing");
        registry.addRecipeClickArea(GuiFurnace.class, 78, 32, 28, 23, "minecraft.smelting", "minecraft.fuel");
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerWorkbench.class, "minecraft.crafting", 1, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(new PlayerRecipeTransferHandler(jeiHelpers.recipeTransferHandlerHelper()), "minecraft.crafting");
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.smelting", 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.fuel", 1, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerBrewingStand.class, "minecraft.brewing", 0, 4, 5, 36);
        registry.addRecipeCategoryCraftingItem(new ItemStack(Blocks.field_150462_ai), "minecraft.crafting");
        registry.addRecipeCategoryCraftingItem(new ItemStack(Blocks.field_150460_al), "minecraft.smelting", "minecraft.fuel");
        registry.addRecipeCategoryCraftingItem(new ItemStack(Items.field_151067_bt), "minecraft.brewing");
        registry.addRecipes(CraftingManager.func_77594_a().func_77592_b());
        registry.addRecipes(SmeltingRecipeMaker.getFurnaceRecipes(jeiHelpers));
        registry.addRecipes(FuelRecipeMaker.getFuelRecipes(ingredientRegistry, jeiHelpers));
        registry.addRecipes(BrewingRecipeMaker.getBrewingRecipes(ingredientRegistry));
        registry.addRecipes(TippedArrowRecipeMaker.getTippedArrowRecipes());
        IIngredientBlacklist ingredientBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ingredientBlacklist.addIngredientToBlacklist(new ItemStack(Items.field_151144_bL, 1, 3));
    }
}

