/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.IngredientUtil;
import mezz.jei.util.RecipeCategoryComparator;

public class RecipeMap {
    @Deprecated
    private final Table<IRecipeCategory, String, List<Object>> recipeTable = HashBasedTable.create();
    private final Table<IRecipeCategory, String, List<IRecipeWrapper>> recipeWrapperTable = HashBasedTable.create();
    private final ArrayListMultimap<String, String> categoryUidMap = ArrayListMultimap.create();
    private final Ordering<String> recipeCategoryOrdering;
    private final IIngredientRegistry ingredientRegistry;

    public RecipeMap(RecipeCategoryComparator recipeCategoryComparator, IIngredientRegistry ingredientRegistry) {
        this.recipeCategoryOrdering = Ordering.from((Comparator)recipeCategoryComparator);
        this.ingredientRegistry = ingredientRegistry;
    }

    public <V> List<String> getRecipeCategories(V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        HashSet recipeCategories = new HashSet();
        for (String key : IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
            recipeCategories.addAll(this.categoryUidMap.get((Object)key));
        }
        return this.recipeCategoryOrdering.immutableSortedCopy(recipeCategories);
    }

    public <V> void addRecipeCategory(IRecipeCategory recipeCategory, V ingredient) {
        String recipeCategoryUid;
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        String key = ingredientHelper.getUniqueId(ingredient);
        List recipeCategories = this.categoryUidMap.get((Object)key);
        if (!recipeCategories.contains(recipeCategoryUid = recipeCategory.getUid())) {
            recipeCategories.add(recipeCategoryUid);
        }
    }

    public <T extends IRecipeWrapper, V> ImmutableList<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        Map recipesForType = this.recipeWrapperTable.row(recipeCategory);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String key : IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
            List recipes = (List)recipesForType.get(key);
            if (recipes == null) continue;
            listBuilder.addAll((Iterable)recipes);
        }
        return listBuilder.build();
    }

    @Deprecated
    public <V> ImmutableList<Object> getRecipes(IRecipeCategory recipeCategory, V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        Map recipesForType = this.recipeTable.row((Object)recipeCategory);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String key : IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
            List recipes = (List)recipesForType.get(key);
            if (recipes == null) continue;
            listBuilder.addAll((Iterable)recipes);
        }
        return listBuilder.build();
    }

    public <T extends IRecipeWrapper, R> void addRecipe(R recipe, T recipeWrapper, IRecipeCategory<T> recipeCategory, Map<Class, List> ingredientsByType) {
        for (Map.Entry<Class, List> entry : ingredientsByType.entrySet()) {
            if (entry == null) continue;
            this.addRecipe(recipe, recipeWrapper, recipeCategory, entry.getKey(), entry.getValue());
        }
    }

    private <T extends IRecipeWrapper, V, R> void addRecipe(R recipe, T recipeWrapper, IRecipeCategory<T> recipeCategory, Class<V> ingredientClass, List<V> ingredients) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredientClass);
        Map recipesForType = this.recipeTable.row(recipeCategory);
        Map recipesWrappersForType = this.recipeWrapperTable.row(recipeCategory);
        HashSet<String> uniqueIds = new HashSet<String>();
        ingredients = ingredientHelper.expandSubtypes(ingredients);
        for (V ingredient : ingredients) {
            String key;
            if (ingredient == null || uniqueIds.contains(key = ingredientHelper.getUniqueId(ingredient))) continue;
            uniqueIds.add(key);
            List recipes = (List)recipesForType.get(key);
            if (recipes == null) {
                recipes = Lists.newArrayList();
                recipesForType.put(key, recipes);
            }
            recipes.add(recipe);
            List recipeWrappers = (List)recipesWrappersForType.get(key);
            if (recipeWrappers == null) {
                recipeWrappers = Lists.newArrayList();
                recipesWrappersForType.put(key, recipeWrappers);
            }
            recipeWrappers.add(recipeWrapper);
            this.addRecipeCategory(recipeCategory, ingredient);
        }
    }

    public <T extends IRecipeWrapper, R> void removeRecipe(R recipe, T recipeWrapper, IRecipeCategory<T> recipeCategory, Map<Class, List> ingredientsByType) {
        for (Map.Entry<Class, List> entry : ingredientsByType.entrySet()) {
            if (entry == null) continue;
            this.removeRecipe(recipe, recipeWrapper, recipeCategory, entry.getKey(), entry.getValue());
        }
    }

    private <T extends IRecipeWrapper, V, R> void removeRecipe(R recipe, T recipeWrapper, IRecipeCategory<T> recipeCategory, Class<V> ingredientClass, List<V> ingredients) {
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredientClass);
        Map recipesForType = this.recipeTable.row(recipeCategory);
        Map recipesWrappersForType = this.recipeWrapperTable.row(recipeCategory);
        ingredients = ingredientHelper.expandSubtypes(ingredients);
        for (V ingredient : ingredients) {
            if (ingredient == null) continue;
            List<String> uniqueIdsWithWildcard = IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient);
            for (String key : uniqueIdsWithWildcard) {
                List recipeWrappers;
                List recipes = (List)recipesForType.get(key);
                if (recipes != null) {
                    recipes.remove(recipe);
                    if (recipes.isEmpty()) {
                        this.categoryUidMap.remove((Object)key, (Object)recipeCategory.getUid());
                        recipesForType.remove(key);
                    }
                }
                if ((recipeWrappers = (List)recipesWrappersForType.get(key)) == null) continue;
                recipeWrappers.remove(recipeWrapper);
                if (!recipeWrappers.isEmpty()) continue;
                recipesWrappersForType.remove(key);
            }
        }
    }
}

