/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.plugins.vanilla.furnace.FurnaceRecipeCategory;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipe;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FurnaceSmeltingCategory
extends FurnaceRecipeCategory<SmeltingRecipe> {
    private final IDrawable background;
    private final String localizedName;

    public FurnaceSmeltingCategory(IGuiHelper guiHelper) {
        super(guiHelper);
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.background = guiHelper.createDrawable(location, 55, 16, 82, 54);
        this.localizedName = Translator.translateToLocal("gui.jei.category.smelting");
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 2, 20);
        this.arrow.draw(minecraft, 24, 18);
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public String getUid() {
        return "minecraft.smelting";
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, SmeltingRecipe recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        List<List<ItemStack>> inputs = recipeWrapper.getInputs();
        guiItemStacks.set(0, inputs.get(0));
        List<ItemStack> outputs = recipeWrapper.getOutputs();
        guiItemStacks.set(2, outputs.get(0));
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, SmeltingRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }
}

