/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.IngredientRegistry;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.util.Log;

public class ModIngredientRegistration
implements IModIngredientRegistration {
    private final Map<Class, Collection> allIngredientsMap = new HashMap<Class, Collection>();
    private final Map<Class, IIngredientHelper> ingredientHelperMap = new HashMap<Class, IIngredientHelper>();
    private final Map<Class, IIngredientRenderer> ingredientRendererMap = new HashMap<Class, IIngredientRenderer>();

    @Override
    public <V> void register(@Nullable Class<V> ingredientClass, @Nullable Collection<V> allIngredients, @Nullable IIngredientHelper<V> ingredientHelper, @Nullable IIngredientRenderer<V> ingredientRenderer) {
        if (ingredientClass == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Null ingredientClass", e);
            return;
        }
        if (allIngredients == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Null allIngredients", e);
            return;
        }
        if (ingredientHelper == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Null ingredientHelper", e);
            return;
        }
        if (ingredientRenderer == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Null ingredientRendererFactory", e);
            return;
        }
        this.allIngredientsMap.put(ingredientClass, allIngredients);
        this.ingredientHelperMap.put(ingredientClass, ingredientHelper);
        this.ingredientRendererMap.put(ingredientClass, ingredientRenderer);
    }

    public IngredientRegistry createIngredientRegistry() {
        IdentityHashMap<Class, List> ingredientsMap = new IdentityHashMap<Class, List>();
        for (Class ingredientClass : this.allIngredientsMap.keySet()) {
            Collection ingredients = this.allIngredientsMap.get(ingredientClass);
            ingredientsMap.put(ingredientClass, Lists.newArrayList((Iterable)ingredients));
        }
        return new IngredientRegistry(ingredientsMap, (ImmutableMap<Class, IIngredientHelper>)ImmutableMap.copyOf(this.ingredientHelperMap), (ImmutableMap<Class, IIngredientRenderer>)ImmutableMap.copyOf(this.ingredientRendererMap));
    }
}

