/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.FocusedRecipes;

public class IngredientLookupState {
    private final IRecipeManager recipeManager;
    @Nullable
    private final Focus<?> focus;
    private final ImmutableList<IRecipeCategory<?>> recipeCategories;
    private int recipeCategoryIndex;
    private int recipeIndex;
    private int recipesPerPage;
    @Nullable
    private FocusedRecipes<?> focusedRecipes;

    public IngredientLookupState(IRecipeManager recipeManager, @Nullable Focus<?> focus) {
        this.recipeManager = recipeManager;
        this.focus = focus;
        this.recipeCategories = ImmutableList.copyOf(recipeManager.getRecipeCategories(focus, false));
    }

    @Nullable
    public Focus<?> getFocus() {
        return this.focus;
    }

    public ImmutableList<IRecipeCategory<?>> getRecipeCategories() {
        return this.recipeCategories;
    }

    public int getRecipeCategoryIndex() {
        return this.recipeCategoryIndex;
    }

    public boolean setRecipeCategory(IRecipeCategory<?> recipeCategory) {
        int recipeCategoryIndex = this.recipeCategories.indexOf(recipeCategory);
        if (recipeCategoryIndex >= 0) {
            this.setRecipeCategoryIndex(recipeCategoryIndex);
            return true;
        }
        return false;
    }

    public void setRecipeCategoryIndex(int recipeCategoryIndex) {
        Preconditions.checkArgument((recipeCategoryIndex >= 0 ? 1 : 0) != 0, (Object)"Recipe category index cannot be negative.");
        this.recipeCategoryIndex = recipeCategoryIndex;
        this.recipeIndex = 0;
        this.focusedRecipes = null;
    }

    public void nextRecipeCategory() {
        int recipesTypesCount = this.getRecipeCategories().size();
        this.setRecipeCategoryIndex((this.getRecipeCategoryIndex() + 1) % recipesTypesCount);
    }

    public void previousRecipeCategory() {
        int recipesTypesCount = this.getRecipeCategories().size();
        this.setRecipeCategoryIndex((recipesTypesCount + this.getRecipeCategoryIndex() - 1) % recipesTypesCount);
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public void setRecipeIndex(int recipeIndex) {
        this.recipeIndex = recipeIndex;
    }

    public int getRecipesPerPage() {
        return this.recipesPerPage;
    }

    public void setRecipesPerPage(int recipesPerPage) {
        this.recipesPerPage = recipesPerPage;
    }

    public FocusedRecipes<?> getFocusedRecipes() {
        if (this.focusedRecipes == null) {
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategories.get(this.recipeCategoryIndex);
            this.focusedRecipes = FocusedRecipes.create(this.focus, this.recipeManager, recipeCategory);
        }
        return this.focusedRecipes;
    }
}

