/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableBlank;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.click.MouseClickState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiIconToggleButton {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final GuiIconButton button;
    private final HoverChecker hoverChecker;
    private final IMouseHandler mouseHandler;

    public GuiIconToggleButton(IDrawable offIcon, IDrawable onIcon) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.button = new GuiIconButton(new DrawableBlank(0, 0), b -> {});
        this.hoverChecker = new HoverChecker();
        this.hoverChecker.updateBounds(this.button);
        this.mouseHandler = new MouseHandler();
    }

    public void updateBounds(Rectangle2d area) {
        this.button.func_230991_b_(area.func_199316_c());
        this.button.setHeight(area.func_199317_d());
        this.button.field_230690_l_ = area.func_199318_a();
        this.button.field_230691_m_ = area.func_199319_b();
        this.hoverChecker.updateBounds(this.button);
    }

    public void draw(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        IDrawable icon = this.isIconToggledOn() ? this.onIcon : this.offIcon;
        icon.draw(matrixStack, this.button.field_230690_l_ + 2, this.button.field_230691_m_ + 2);
    }

    public final boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IMouseHandler getMouseHandler() {
        return this.mouseHandler;
    }

    public final void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            this.getTooltips(tooltip);
            TooltipRenderer.drawHoveringText(tooltip, mouseX, mouseY, 150, matrixStack);
        }
    }

    protected abstract void getTooltips(List<ITextComponent> var1);

    protected abstract boolean isIconToggledOn();

    protected abstract boolean onMouseClicked(Screen var1, double var2, double var4, int var6, MouseClickState var7);

    private class MouseHandler
    implements IMouseHandler {
        private MouseHandler() {
        }

        @Override
        @Nullable
        public final IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            IMouseHandler mouseHandler;
            IMouseHandler handled;
            if (GuiIconToggleButton.this.isMouseOver(mouseX, mouseY) && (handled = (mouseHandler = GuiIconToggleButton.this.button.getMouseHandler()).handleClick(screen, mouseX, mouseY, mouseButton, clickState)) != null && GuiIconToggleButton.this.onMouseClicked(screen, mouseX, mouseY, mouseButton, clickState)) {
                return this;
            }
            return null;
        }
    }
}

