/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void render(MatrixStack matrixStack, int xPosition, int yPosition, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)matrixStack.last().pose());
            RenderSystem.enableDepthTest();
            RenderHelper.turnBackOn();
            Minecraft minecraft = Minecraft.getInstance();
            FontRenderer font = this.getFontRenderer(minecraft, ingredient);
            ItemRenderer itemRenderer = minecraft.getItemRenderer();
            itemRenderer.renderAndDecorateItem(null, ingredient, xPosition, yPosition);
            itemRenderer.renderGuiItemDecorations(font, ingredient, xPosition, yPosition, null);
            RenderSystem.disableBlend();
            RenderHelper.turnOff();
            RenderSystem.popMatrix();
        }
    }

    @Override
    public List<ITextComponent> getTooltip(ItemStack ingredient, ITooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPlayerEntity player = minecraft.player;
        try {
            return ingredient.getTooltipLines((PlayerEntity)player, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            LOGGER.error("Failed to get tooltip: {}", (Object)itemStackInfo, (Object)e);
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            TranslationTextComponent crash = new TranslationTextComponent("jei.tooltip.error.crash");
            list.add((ITextComponent)crash.withStyle(TextFormatting.RED));
            return list;
        }
    }

    @Override
    public FontRenderer getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        FontRenderer fontRenderer = ingredient.getItem().getFontRenderer(ingredient);
        if (fontRenderer == null) {
            fontRenderer = minecraft.font;
        }
        return fontRenderer;
    }
}

