/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.gui.HoverChecker;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ShapelessIcon {
    private static final int scale = 4;
    private final IDrawable icon = Internal.getTextures().getShapelessIcon();
    private final HoverChecker hoverChecker;

    public ShapelessIcon() {
        int iconBottom = this.icon.getHeight() / 4;
        int iconLeft = 116 - this.icon.getWidth() / 4;
        int iconRight = iconLeft + this.icon.getWidth() / 4;
        this.hoverChecker = new HoverChecker(0, iconBottom, iconLeft, iconRight);
    }

    public void draw(MatrixStack matrixStack, int recipeWidth) {
        int shapelessIconX = recipeWidth - this.icon.getWidth() / 4;
        matrixStack.pushPose();
        matrixStack.translate((double)shapelessIconX, 0.0, 0.0);
        matrixStack.scale(0.25f, 0.25f, 1.0f);
        this.icon.draw(matrixStack);
        matrixStack.popPose();
    }

    @Nullable
    public List<ITextComponent> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(new TranslationTextComponent("jei.tooltip.shapeless.recipe"));
        }
        return null;
    }
}

