/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class ExpandNewLineTextAcceptor
implements ITextProperties.IStyledTextAcceptor<Void> {
    private final List<ITextProperties> lines = new ArrayList<ITextProperties>();
    @Nullable
    private IFormattableTextComponent lastComponent;

    public Optional<Void> accept(Style style, String line) {
        String[] descriptionLineExpanded = line.split("\\\\n");
        for (int i = 0; i < descriptionLineExpanded.length; ++i) {
            String s = descriptionLineExpanded[i];
            if (s.isEmpty()) {
                if (i == 0 && this.lastComponent != null) {
                    this.lines.add((ITextProperties)this.lastComponent);
                    this.lastComponent = null;
                    continue;
                }
                this.lines.add((ITextProperties)StringTextComponent.EMPTY);
                continue;
            }
            StringTextComponent textComponent = new StringTextComponent(s);
            textComponent.setStyle(style);
            if (this.lastComponent != null) {
                if (i == 0) {
                    if (!this.lastComponent.getStyle().isEmpty() && !this.lastComponent.getStyle().equals((Object)style)) {
                        this.lastComponent = new StringTextComponent("").append((ITextComponent)this.lastComponent);
                    }
                    this.lastComponent.append((ITextComponent)textComponent);
                    continue;
                }
                this.lines.add((ITextProperties)this.lastComponent);
                this.lastComponent = null;
            }
            if (i == descriptionLineExpanded.length - 1) {
                this.lastComponent = textComponent;
                continue;
            }
            this.lines.add((ITextProperties)textComponent);
        }
        return Optional.empty();
    }

    public void addLinesTo(List<ITextProperties> descriptionLinesExpanded) {
        descriptionLinesExpanded.addAll(this.lines);
        if (this.lastComponent != null) {
            descriptionLinesExpanded.add((ITextProperties)this.lastComponent);
        }
    }
}

