/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.SearchMode;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.render.IngredientRenderHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class IngredientListElementRenderer<T> {
    private static final int BLACKLIST_COLOR = -65536;
    private static final Rectangle2d DEFAULT_AREA = new Rectangle2d(0, 0, 16, 16);
    protected final IIngredientListElement<T> element;
    protected final IIngredientRenderer<T> ingredientRenderer;
    protected final IIngredientHelper<T> ingredientHelper;
    protected Rectangle2d area = DEFAULT_AREA;
    protected int padding;

    public IngredientListElementRenderer(IIngredientListElement<T> element) {
        this.element = element;
        T ingredient = element.getIngredient();
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientType<T> ingredientType = ingredientManager.getIngredientType(ingredient);
        this.ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        this.ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
    }

    public void setArea(Rectangle2d area) {
        this.area = area;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public IIngredientListElement<T> getElement() {
        return this.element;
    }

    public Rectangle2d getArea() {
        return this.area;
    }

    public void renderSlow(MatrixStack matrixStack, IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isEditModeEnabled()) {
            this.renderEditMode(matrixStack, this.area, this.padding, editModeConfig);
        }
        try {
            T ingredient = this.element.getIngredient();
            this.ingredientRenderer.render(matrixStack, this.area.getX() + this.padding, this.area.getY() + this.padding, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    public void drawHighlight(MatrixStack matrixStack) {
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        AbstractGui.fill((MatrixStack)matrixStack, (int)this.area.getX(), (int)this.area.getY(), (int)(this.area.getX() + this.area.getWidth()), (int)(this.area.getY() + this.area.getHeight()), (int)-2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public void drawTooltip(MatrixStack matrixStack, int mouseX, int mouseY, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig) {
        T ingredient = this.element.getIngredient();
        List<ITextProperties> tooltip = this.getTooltip(ingredientFilterConfig, worldConfig);
        TooltipRenderer.drawHoveringText(ingredient, tooltip, mouseX, mouseY, matrixStack);
    }

    protected void renderEditMode(MatrixStack matrixStack, Rectangle2d area, int padding, IEditModeConfig editModeConfig) {
        T ingredient = this.element.getIngredient();
        if (editModeConfig.isIngredientOnConfigBlacklist(ingredient, this.ingredientHelper)) {
            AbstractGui.fill((MatrixStack)matrixStack, (int)(area.getX() + padding), (int)(area.getY() + padding), (int)(area.getX() + 16 + padding), (int)(area.getY() + 16 + padding), (int)-65536);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private List<ITextProperties> getTooltip(IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig) {
        T ingredient = this.element.getIngredient();
        IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
        List<ITextComponent> ingredientTooltipSafe = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, this.ingredientRenderer, this.ingredientHelper, modIdHelper);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>(ingredientTooltipSafe);
        Minecraft minecraft = Minecraft.getInstance();
        int maxWidth = 150;
        for (ITextProperties iTextProperties : tooltip) {
            int width = minecraft.font.width(iTextProperties);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(minecraft, tooltip, maxWidth);
        }
        if (worldConfig.isEditModeEnabled()) {
            IngredientListElementRenderer.addEditModeInfoToTooltip(minecraft, tooltip, maxWidth);
        }
        return tooltip;
    }

    private void addColorSearchInfoToTooltip(Minecraft minecraft, List<ITextProperties> tooltip, int maxWidth) {
        T ingredient;
        Iterable<Integer> colors;
        ColorNamer colorNamer = Internal.getColorNamer();
        Collection<String> colorNames = colorNamer.getColorNames(colors = this.ingredientHelper.getColors(ingredient = this.element.getIngredient()), false);
        if (!colorNames.isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            TranslationTextComponent colorTranslation = new TranslationTextComponent("jei.tooltip.item.colors", new Object[]{colorNamesString});
            IFormattableTextComponent colorNamesLocalizedString = colorTranslation.withStyle(TextFormatting.GRAY);
            tooltip.addAll(minecraft.font.getSplitter().splitLines((ITextProperties)colorNamesLocalizedString, maxWidth, Style.EMPTY));
        }
    }

    private static void addEditModeInfoToTooltip(Minecraft minecraft, List<ITextProperties> tooltip, int maxWidth) {
        tooltip.add((ITextProperties)StringTextComponent.EMPTY);
        TranslationTextComponent description = new TranslationTextComponent("gui.jei.editMode.description");
        tooltip.add((ITextProperties)description.withStyle(TextFormatting.DARK_GREEN));
        TranslationTextComponent controlKeyLocalization = new TranslationTextComponent(Minecraft.ON_OSX ? "key.jei.ctrl.mac" : "key.jei.ctrl");
        TranslationTextComponent hide = new TranslationTextComponent("gui.jei.editMode.description.hide", new Object[]{controlKeyLocalization});
        IFormattableTextComponent hideMessage = hide.withStyle(TextFormatting.GRAY);
        tooltip.addAll(minecraft.font.getSplitter().splitLines((ITextProperties)hideMessage, maxWidth, Style.EMPTY));
        TranslationTextComponent hideWild = new TranslationTextComponent("gui.jei.editMode.description.hide.wild", new Object[]{controlKeyLocalization});
        IFormattableTextComponent hideWildMessage = hideWild.withStyle(TextFormatting.GRAY);
        tooltip.addAll(minecraft.font.getSplitter().splitLines((ITextProperties)hideWildMessage, maxWidth, Style.EMPTY));
    }
}

